/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.init.decorator;

import com.phonepe.sdk.javasdk.transaction.init.decorator.InitRequestDecorator;
import com.phonepe.sdk.javasdk.transaction.init.decorator.TransactionInitComponent;
import com.phonepe.sdk.javasdk.transaction.init.models.AllowedAccountConstraint;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.models.MerchantConstraints;
import com.phonepe.sdk.javasdk.transaction.init.models.MerchantContext;
import java.util.List;

public class AccountConstraintsDecorator
extends InitRequestDecorator {
    private List<AllowedAccountConstraint> allowedAccountConstraints;

    public AccountConstraintsDecorator(TransactionInitComponent transactionInitComponent, List<AllowedAccountConstraint> allowedAccountConstraints) {
        super(transactionInitComponent);
        this.allowedAccountConstraints = allowedAccountConstraints;
    }

    @Override
    public InitRequest getInitRequest() {
        InitRequest initRequest = this.transactionInitComponent.getInitRequest();
        MerchantContext merchantContext = initRequest.getMerchantContext();
        MerchantConstraints merchantConstraints = MerchantConstraints.builder().account(this.allowedAccountConstraints).build();
        if (merchantContext != null) {
            merchantContext.setConstraints(merchantConstraints);
        } else {
            merchantContext = MerchantContext.builder().constraints(merchantConstraints).build();
        }
        initRequest.setMerchantContext(merchantContext);
        return initRequest;
    }

    public static AccountConstraintsDecoratorBuilder builder() {
        return new AccountConstraintsDecoratorBuilder();
    }

    public String toString() {
        return "AccountConstraintsDecorator(super=" + super.toString() + ", allowedAccountConstraints=" + this.allowedAccountConstraints + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountConstraintsDecorator)) {
            return false;
        }
        AccountConstraintsDecorator other = (AccountConstraintsDecorator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<AllowedAccountConstraint> this$allowedAccountConstraints = this.allowedAccountConstraints;
        List<AllowedAccountConstraint> other$allowedAccountConstraints = other.allowedAccountConstraints;
        return !(this$allowedAccountConstraints == null ? other$allowedAccountConstraints != null : !((Object)this$allowedAccountConstraints).equals(other$allowedAccountConstraints));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountConstraintsDecorator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<AllowedAccountConstraint> $allowedAccountConstraints = this.allowedAccountConstraints;
        result = result * 59 + ($allowedAccountConstraints == null ? 43 : ((Object)$allowedAccountConstraints).hashCode());
        return result;
    }

    public static class AccountConstraintsDecoratorBuilder {
        private TransactionInitComponent transactionInitComponent;
        private List<AllowedAccountConstraint> allowedAccountConstraints;

        AccountConstraintsDecoratorBuilder() {
        }

        public AccountConstraintsDecoratorBuilder transactionInitComponent(TransactionInitComponent transactionInitComponent) {
            this.transactionInitComponent = transactionInitComponent;
            return this;
        }

        public AccountConstraintsDecoratorBuilder allowedAccountConstraints(List<AllowedAccountConstraint> allowedAccountConstraints) {
            this.allowedAccountConstraints = allowedAccountConstraints;
            return this;
        }

        public AccountConstraintsDecorator build() {
            return new AccountConstraintsDecorator(this.transactionInitComponent, this.allowedAccountConstraints);
        }

        public String toString() {
            return "AccountConstraintsDecorator.AccountConstraintsDecoratorBuilder(transactionInitComponent=" + this.transactionInitComponent + ", allowedAccountConstraints=" + this.allowedAccountConstraints + ")";
        }
    }
}

