/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.init.decorator;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.phonepe.sdk.javasdk.transaction.init.decorator.TransactionInitComponent;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;

public class BaseTransactionInit
implements TransactionInitComponent {
    private String merchantId;
    private String transactionId;
    private Long amount;
    private String merchantOrderId;
    private String merchantUserId;
    private String subMerchant;
    private String subMerchantId;
    private String mobileNumber;
    private String message;
    private String emailId;
    private String shortName;

    @Override
    public InitRequest getInitRequest() {
        Preconditions.checkNotNull((Object)this.merchantId);
        Preconditions.checkNotNull((Object)this.transactionId);
        Preconditions.checkNotNull((Object)this.amount);
        if (Strings.isNullOrEmpty((String)this.message)) {
            this.message = this.getGenericMessage(this.merchantOrderId);
        }
        return InitRequest.builder().merchantId(this.merchantId).transactionId(this.transactionId).merchantOrderId(this.merchantOrderId).merchantUserId(this.merchantUserId).email(this.emailId).subMerchant(this.subMerchant).subMerchantId(this.subMerchantId).mobileNumber(this.mobileNumber).shortName(this.shortName).amount(this.amount).message(this.message).build();
    }

    private String getGenericMessage(String orderId) {
        return String.format("Payment for orderId: %s", orderId);
    }

    public static BaseTransactionInitBuilder builder() {
        return new BaseTransactionInitBuilder();
    }

    public BaseTransactionInit(String merchantId, String transactionId, Long amount, String merchantOrderId, String merchantUserId, String subMerchant, String subMerchantId, String mobileNumber, String message, String emailId, String shortName) {
        this.merchantId = merchantId;
        this.transactionId = transactionId;
        this.amount = amount;
        this.merchantOrderId = merchantOrderId;
        this.merchantUserId = merchantUserId;
        this.subMerchant = subMerchant;
        this.subMerchantId = subMerchantId;
        this.mobileNumber = mobileNumber;
        this.message = message;
        this.emailId = emailId;
        this.shortName = shortName;
    }

    public static class BaseTransactionInitBuilder {
        private String merchantId;
        private String transactionId;
        private Long amount;
        private String merchantOrderId;
        private String merchantUserId;
        private String subMerchant;
        private String subMerchantId;
        private String mobileNumber;
        private String message;
        private String emailId;
        private String shortName;

        BaseTransactionInitBuilder() {
        }

        public BaseTransactionInitBuilder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public BaseTransactionInitBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public BaseTransactionInitBuilder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public BaseTransactionInitBuilder merchantOrderId(String merchantOrderId) {
            this.merchantOrderId = merchantOrderId;
            return this;
        }

        public BaseTransactionInitBuilder merchantUserId(String merchantUserId) {
            this.merchantUserId = merchantUserId;
            return this;
        }

        public BaseTransactionInitBuilder subMerchant(String subMerchant) {
            this.subMerchant = subMerchant;
            return this;
        }

        public BaseTransactionInitBuilder subMerchantId(String subMerchantId) {
            this.subMerchantId = subMerchantId;
            return this;
        }

        public BaseTransactionInitBuilder mobileNumber(String mobileNumber) {
            this.mobileNumber = mobileNumber;
            return this;
        }

        public BaseTransactionInitBuilder message(String message) {
            this.message = message;
            return this;
        }

        public BaseTransactionInitBuilder emailId(String emailId) {
            this.emailId = emailId;
            return this;
        }

        public BaseTransactionInitBuilder shortName(String shortName) {
            this.shortName = shortName;
            return this;
        }

        public BaseTransactionInit build() {
            return new BaseTransactionInit(this.merchantId, this.transactionId, this.amount, this.merchantOrderId, this.merchantUserId, this.subMerchant, this.subMerchantId, this.mobileNumber, this.message, this.emailId, this.shortName);
        }

        public String toString() {
            return "BaseTransactionInit.BaseTransactionInitBuilder(merchantId=" + this.merchantId + ", transactionId=" + this.transactionId + ", amount=" + this.amount + ", merchantOrderId=" + this.merchantOrderId + ", merchantUserId=" + this.merchantUserId + ", subMerchant=" + this.subMerchant + ", subMerchantId=" + this.subMerchantId + ", mobileNumber=" + this.mobileNumber + ", message=" + this.message + ", emailId=" + this.emailId + ", shortName=" + this.shortName + ")";
        }
    }
}

