package com.phonepe.sdk.javasdk.config;

import com.phonepe.sdk.javasdk.config.models.Endpoint;
import com.phonepe.sdk.javasdk.config.models.enums.ConfigType;
import lombok.AllArgsConstructor;
import lombok.Builder;
import okhttp3.HttpUrl;
import org.apache.commons.lang.StringUtils;

import java.net.URI;

@Builder
@AllArgsConstructor
public class URLCreator {

    private DefaultEndpointCreator defaultEndpointCreator;
    private DefaultUrlCreator defaultUrlCreator;
    private Endpoint endpoint;

    public HttpUrl getHttpUrl(final ConfigType configType,
                              final String overrideHost,
                              final String... pathFormatArgs) {

        String hostEndpoint = StringUtils.isNotEmpty(overrideHost) ? overrideHost : getDefaultHostEndpoint();
        final String url = getCompleteUrl(hostEndpoint, configType.accept(defaultUrlCreator), pathFormatArgs);
        return HttpUrl.get(URI.create(url));
    }

    private String getDefaultHostEndpoint(){
        return StringUtils.isNotEmpty(this.endpoint.getOverrideHost())
               ? this.endpoint.getOverrideHost()
               : this.endpoint
                       .getEnvironment()
                       .accept(defaultEndpointCreator);
    }

    private String getCompleteUrl(final String hostEndpoint, final String pathFormatString, String... pathFormatArgs) {
        final String path = String.format(pathFormatString, pathFormatArgs);
        return String.format("%s%s",
                             hostEndpoint,
                             path);
    }

}
