package com.phonepe.sdk.javasdk.config.models;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;

@Data
@NoArgsConstructor
public class PhonePeConfig {

    @Valid
    private Endpoint endpoint = Endpoint
            .builder()
            .build();

    @Valid
    private HttpClientConfig httpClientConfig = HttpClientConfig
            .builder()
            .build();

    @Valid
    private InitConfig initConfig = InitConfig
            .builder()
            .build();

    @Valid
    private StatusConfig statusConfig = StatusConfig
            .builder()
            .build();

    @Builder
    public PhonePeConfig(final Endpoint endpoint,
                         final HttpClientConfig httpClientConfig,
                         final InitConfig initConfig,
                         final StatusConfig statusConfig) {
        this.endpoint = endpoint == null
                        ? Endpoint
                                .builder()
                                .build()
                        : endpoint;
        this.httpClientConfig = httpClientConfig == null
                                ? HttpClientConfig
                                        .builder()
                                        .build()
                                : httpClientConfig;
        this.initConfig = initConfig == null
                          ? InitConfig
                                  .builder()
                                  .build()
                          : initConfig;
        this.statusConfig = statusConfig == null
                            ? StatusConfig
                                    .builder()
                                    .build()
                            : statusConfig;
    }
}
