package com.phonepe.sdk.javasdk.config.models.enums;

import lombok.Getter;

public enum APIVersion {

    @Deprecated
    V1("v1") {
        @Override
        public <T> T accept(APIVersionVisitor<T> visitor) {
            return visitor.visitV1();
        }
    },
    @Deprecated
    V2("v2") {
        @Override
        public <T> T accept(APIVersionVisitor<T> visitor) {
            return visitor.visitV2();
        }
    }, V3("v3") {
        @Override
        public <T> T accept(APIVersionVisitor<T> visitor) {
            return visitor.visitV3();
        }
    }, V4("v4") {
        @Override
        public <T> T accept(APIVersionVisitor<T> visitor) {
            return visitor.visitV4();
        }
    };

    @Getter
    private final String value;

    APIVersion(final String value) {
        this.value = value;
    }

    public abstract <T> T accept(APIVersionVisitor<T> visitor);

    public interface APIVersionVisitor<T> {
        T visitV1();

        T visitV2();

        T visitV3();

        T visitV4();
    }
}
