package com.phonepe.sdk.javasdk.transaction.status;

import com.phonepe.sdk.javasdk.transaction.models.enums.TransactionStatusCode;
import com.phonepe.sdk.javasdk.transaction.status.models.enums.PaymentState;

public class PaymentStateCreator implements TransactionStatusCode.TransactionStatusCodeVisitor<PaymentState> {

    @Override
    public PaymentState visitPaymentPending() {
        return PaymentState.PAYMENT_PENDING;
    }

    @Override
    public PaymentState visitInternalServerError() {
        return PaymentState.PAYMENT_PENDING;
    }

    @Override
    public PaymentState visitPaymentSuccess() {
        return PaymentState.PAYMENT_SUCCESS;
    }

    @Override
    public PaymentState visitPaymentError() {
        return PaymentState.PAYMENT_FAILED;
    }

    @Override
    public PaymentState visitPaymentDeclined() {
        return PaymentState.PAYMENT_FAILED;
    }

    @Override
    public PaymentState visitPaymentCancelled() {
        return PaymentState.PAYMENT_FAILED;
    }

    @Override
    public PaymentState visitTransactionNotFound() {
        return PaymentState.TRANSACTION_NOT_FOUND;
    }

    @Override
    public PaymentState visitUnknown() {
        throw new EnumConstantNotPresentException(TransactionStatusCode.class,"Unknown status code in transaction status response");
    }
}
