/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.callback;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpResponse;
import com.phonepe.sdk.javasdk.transaction.callback.DefaultStatusResponseHandler;
import com.phonepe.sdk.javasdk.transaction.callback.StatusResponseHandler;
import com.phonepe.sdk.javasdk.transaction.models.Base64Request;
import com.phonepe.sdk.javasdk.transaction.status.TransactionStatusChecker;
import com.phonepe.sdk.javasdk.transaction.status.models.StatusResponse;
import com.phonepe.sdk.javasdk.transaction.status.models.TransactionStatusResponse;
import com.phonepe.sdk.javasdk.utils.Base64Utils;
import com.phonepe.sdk.javasdk.utils.KeyUtils;
import com.phonepe.sdk.javasdk.utils.MapperUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(CallbackHandler.class);
    private TransactionStatusChecker transactionStatusChecker;
    private MerchantConfig merchantConfig;
    private ExecutorService executorService;
    private StatusResponseHandler defaultResponseHandler;

    public CallbackHandler(TransactionStatusChecker transactionStatusChecker, MerchantConfig merchantConfig) {
        this.transactionStatusChecker = transactionStatusChecker;
        this.merchantConfig = merchantConfig;
        this.executorService = Executors.newCachedThreadPool();
        this.defaultResponseHandler = new DefaultStatusResponseHandler();
    }

    public void handleCallback(String responseReceived, String checksum, long transactionAmount, StatusResponseHandler customResponseHandler) throws PhonePeClientException {
        Preconditions.checkNotNull((Object)responseReceived);
        Preconditions.checkNotNull((Object)checksum);
        try {
            String responseBody = Base64Utils.decodeBase64(responseReceived);
            PhonePeHttpResponse transactionStatusResponse = (PhonePeHttpResponse)MapperUtils.getMapper().readValue(responseBody, (TypeReference)new TypeReference<PhonePeHttpResponse<TransactionStatusResponse>>(){});
            int keyIndex = KeyUtils.getKeyIndexFromChecksum(checksum);
            TransactionStatusResponse callbackResponseData = (TransactionStatusResponse)transactionStatusResponse.getData();
            String merchantId = callbackResponseData.getMerchantId();
            Long callbackAmount = callbackResponseData.getAmount();
            List<String> params = this.getParamsList(callbackResponseData);
            this.validateChecksum(responseReceived, checksum, params, keyIndex);
            this.validateTransactionAmount(callbackAmount, transactionAmount);
            this.validateMerchantId(merchantId);
            String transactionId = ((TransactionStatusResponse)transactionStatusResponse.getData()).getTransactionId();
            this.executorService.submit(this.getRunnable(callbackAmount, transactionId, keyIndex, ObjectUtils.allNotNull((Object[])new Object[]{customResponseHandler}) ? customResponseHandler : this.defaultResponseHandler));
        }
        catch (PhonePeClientException e) {
            log.error("Error occurred while handling callback: {}", (Object)e.getMessage());
            throw e;
        }
        catch (Exception ex) {
            log.error("Error occurred while handling callback: {}", (Object)ex.getMessage());
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("MESSAGE", ex.getMessage());
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.HTTP_CLIENT_ERROR, "Error occurred while handling callback: " + ex.getMessage(), objectMap, ex);
        }
    }

    private void validateMerchantId(String merchantId) throws PhonePeClientException {
        if (this.merchantConfig.getMerchantId().equals(merchantId)) {
            return;
        }
        throw new PhonePeClientException(PhonePeClientException.ErrorCode.VALIDATION_ERROR, "Invalid merchantId in callback response");
    }

    private void validateChecksum(String responseBody, String checksum, List<String> params, int keyIndex) throws PhonePeClientException {
        String apiKey = KeyUtils.getAPIKeyFromIndex(this.merchantConfig.getApiKeys(), keyIndex);
        Base64Request base64Request = Base64Request.builder().request(responseBody).build();
        PhonePeHttpRequest<Base64Request> phonePeHttpRequest = PhonePeHttpRequest.builder().data(base64Request).build();
        String generatedChecksum = this.transactionStatusChecker.getChecksumGenerator().getChecksumValue(phonePeHttpRequest, "", params, apiKey, keyIndex);
        if (checksum.equalsIgnoreCase(generatedChecksum)) {
            return;
        }
        throw new PhonePeClientException(PhonePeClientException.ErrorCode.VALIDATION_ERROR, "Invalid checksum in callback response");
    }

    private void validateTransactionAmount(Long callbackAmount, Long statusResponseAmount) throws PhonePeClientException {
        if (callbackAmount.equals(statusResponseAmount)) {
            return;
        }
        throw new PhonePeClientException(PhonePeClientException.ErrorCode.VALIDATION_ERROR, "Transaction amount mismatch in callback response and status check response or in provided amount");
    }

    private List<String> getParamsList(TransactionStatusResponse transactionStatusResponse) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(transactionStatusResponse.getMerchantId());
        params.add(transactionStatusResponse.getTransactionId());
        params.add(transactionStatusResponse.getAmount().toString());
        return params;
    }

    private Runnable getRunnable(final long callbackAmount, final String transactionId, final int keyIndex, final StatusResponseHandler statusResponseHandler) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    StatusResponse statusResponse = CallbackHandler.this.transactionStatusChecker.checkTransactionStatus(transactionId, keyIndex);
                    CallbackHandler.this.validateTransactionAmount(callbackAmount, statusResponse.getAmount());
                    statusResponseHandler.processStatusResponse(statusResponse);
                }
                catch (Exception ex) {
                    log.error("Error occurred while handling callback: Issue while making status call and processing response: {}", (Object)ex.getMessage());
                }
            }
        };
    }

    public static CallbackHandlerBuilder builder() {
        return new CallbackHandlerBuilder();
    }

    public static class CallbackHandlerBuilder {
        private TransactionStatusChecker transactionStatusChecker;
        private MerchantConfig merchantConfig;

        CallbackHandlerBuilder() {
        }

        public CallbackHandlerBuilder transactionStatusChecker(TransactionStatusChecker transactionStatusChecker) {
            this.transactionStatusChecker = transactionStatusChecker;
            return this;
        }

        public CallbackHandlerBuilder merchantConfig(MerchantConfig merchantConfig) {
            this.merchantConfig = merchantConfig;
            return this;
        }

        public CallbackHandler build() {
            return new CallbackHandler(this.transactionStatusChecker, this.merchantConfig);
        }

        public String toString() {
            return "CallbackHandler.CallbackHandlerBuilder(transactionStatusChecker=" + this.transactionStatusChecker + ", merchantConfig=" + this.merchantConfig + ")";
        }
    }
}

