/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.checksum;

import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.transaction.checksum.ChecksumGenerator;
import com.phonepe.sdk.javasdk.transaction.models.Base64Request;
import com.phonepe.sdk.javasdk.utils.ChecksumUtils;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class BodyChecksumGenerator
implements ChecksumGenerator {
    @Override
    public String getChecksumValue(PhonePeHttpRequest<?> request, String apiURL, List<String> otherParams, String apiKey, int keyIndex) throws PhonePeClientException {
        StringBuilder checksumPayload = new StringBuilder();
        if (ObjectUtils.anyNotNull((Object[])new Object[]{request})) {
            if (request.getData() instanceof Base64Request) {
                PhonePeHttpRequest<?> value = request;
                checksumPayload.append(((Base64Request)value.getData()).getRequest());
            } else {
                throw new PhonePeClientException(PhonePeClientException.ErrorCode.EXECUTION_ERROR, "Base64 Request body not provided to BodyChecksumGenerator");
            }
        }
        checksumPayload.append(apiURL);
        String checksumValue = ChecksumUtils.generateChecksumValue(checksumPayload.toString(), apiKey);
        return ChecksumUtils.generateChecksumHeader(checksumValue, keyIndex);
    }
}

