/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.utils;

import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.google.common.base.Predicate;
import com.phonepe.sdk.javasdk.config.models.RetryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryUtils {
    private static final Logger log = LoggerFactory.getLogger(RetryUtils.class);

    public static <T> Retryer<T> getRetryer(RetryConfig retryConfig, Predicate<T> predicate) {
        return RetryerBuilder.newBuilder().retryIfException().retryIfResult(predicate).withStopStrategy(StopStrategies.stopAfterAttempt((int)retryConfig.getMaxRetry())).withWaitStrategy(retryConfig.getWaitStrategy()).build();
    }

    private RetryUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

