/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.config.models;

import com.github.rholder.retry.WaitStrategies;
import com.github.rholder.retry.WaitStrategy;
import java.util.concurrent.TimeUnit;

public class RetryConfig {
    public static final int MAX_RETRY = 5;
    public static final int MAXIMUM_WAIT_TIME_IN_SECONDS = 6;
    private int maxRetry = 5;
    private int maximumTimeInSeconds = 6;
    private WaitStrategy waitStrategy = WaitStrategies.exponentialWait((long)6L, (TimeUnit)TimeUnit.SECONDS);

    public RetryConfig(Integer maxRetry, Integer maximumTimeInSeconds, WaitStrategy waitStrategy) {
        this.maxRetry = maxRetry == null ? 5 : maxRetry;
        this.maximumTimeInSeconds = maximumTimeInSeconds == null ? 6 : maxRetry;
        this.waitStrategy = waitStrategy == null ? WaitStrategies.exponentialWait((long)6L, (TimeUnit)TimeUnit.SECONDS) : waitStrategy;
    }

    public static RetryConfigBuilder builder() {
        return new RetryConfigBuilder();
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public int getMaximumTimeInSeconds() {
        return this.maximumTimeInSeconds;
    }

    public WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    public void setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
    }

    public void setMaximumTimeInSeconds(int maximumTimeInSeconds) {
        this.maximumTimeInSeconds = maximumTimeInSeconds;
    }

    public void setWaitStrategy(WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetryConfig)) {
            return false;
        }
        RetryConfig other = (RetryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxRetry() != other.getMaxRetry()) {
            return false;
        }
        if (this.getMaximumTimeInSeconds() != other.getMaximumTimeInSeconds()) {
            return false;
        }
        WaitStrategy this$waitStrategy = this.getWaitStrategy();
        WaitStrategy other$waitStrategy = other.getWaitStrategy();
        return !(this$waitStrategy == null ? other$waitStrategy != null : !this$waitStrategy.equals(other$waitStrategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RetryConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxRetry();
        result = result * 59 + this.getMaximumTimeInSeconds();
        WaitStrategy $waitStrategy = this.getWaitStrategy();
        result = result * 59 + ($waitStrategy == null ? 43 : $waitStrategy.hashCode());
        return result;
    }

    public String toString() {
        return "RetryConfig(maxRetry=" + this.getMaxRetry() + ", maximumTimeInSeconds=" + this.getMaximumTimeInSeconds() + ", waitStrategy=" + this.getWaitStrategy() + ")";
    }

    public RetryConfig() {
    }

    public static class RetryConfigBuilder {
        private Integer maxRetry;
        private Integer maximumTimeInSeconds;
        private WaitStrategy waitStrategy;

        RetryConfigBuilder() {
        }

        public RetryConfigBuilder maxRetry(Integer maxRetry) {
            this.maxRetry = maxRetry;
            return this;
        }

        public RetryConfigBuilder maximumTimeInSeconds(Integer maximumTimeInSeconds) {
            this.maximumTimeInSeconds = maximumTimeInSeconds;
            return this;
        }

        public RetryConfigBuilder waitStrategy(WaitStrategy waitStrategy) {
            this.waitStrategy = waitStrategy;
            return this;
        }

        public RetryConfig build() {
            return new RetryConfig(this.maxRetry, this.maximumTimeInSeconds, this.waitStrategy);
        }

        public String toString() {
            return "RetryConfig.RetryConfigBuilder(maxRetry=" + this.maxRetry + ", maximumTimeInSeconds=" + this.maximumTimeInSeconds + ", waitStrategy=" + this.waitStrategy + ")";
        }
    }
}

