/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.status;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.google.common.base.Enums;
import com.google.common.base.Predicate;
import com.phonepe.sdk.javasdk.config.URLCreator;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.StatusConfig;
import com.phonepe.sdk.javasdk.config.models.enums.ConfigType;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpResponse;
import com.phonepe.sdk.javasdk.http.utils.HttpUtils;
import com.phonepe.sdk.javasdk.transaction.checksum.ChecksumGenerator;
import com.phonepe.sdk.javasdk.transaction.client.TransactionCommand;
import com.phonepe.sdk.javasdk.transaction.models.enums.TransactionStatusCode;
import com.phonepe.sdk.javasdk.transaction.status.PaymentStateCreator;
import com.phonepe.sdk.javasdk.transaction.status.models.StatusResponse;
import com.phonepe.sdk.javasdk.transaction.status.models.TransactionStatusResponse;
import com.phonepe.sdk.javasdk.transaction.status.models.enums.PaymentState;
import com.phonepe.sdk.javasdk.utils.KeyUtils;
import com.phonepe.sdk.javasdk.utils.RetryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionStatusChecker {
    private static final Logger log = LoggerFactory.getLogger(TransactionStatusChecker.class);
    private TransactionCommand transactionCommand;
    private StatusConfig statusConfig;
    private MerchantConfig merchantConfig;
    private ChecksumGenerator checksumGenerator;
    private PaymentStateCreator paymentStateCreator;
    private URLCreator urlCreator;

    public TransactionStatusChecker(TransactionCommand transactionCommand, MerchantConfig merchantConfig, StatusConfig statusConfig, ChecksumGenerator checksumGenerator, PaymentStateCreator paymentStateCreator, URLCreator urlCreator) {
        this.transactionCommand = transactionCommand;
        this.merchantConfig = merchantConfig;
        this.statusConfig = statusConfig;
        this.checksumGenerator = checksumGenerator;
        this.paymentStateCreator = paymentStateCreator;
        this.urlCreator = urlCreator;
    }

    public StatusResponse checkTransactionStatus(String transactionId, int keyIndex) throws PhonePeClientException {
        try {
            HttpUrl httpUrl = this.getHttpUrl(transactionId);
            String apiKey = KeyUtils.getAPIKeyFromIndex(this.merchantConfig.getApiKeys(), keyIndex);
            List<String> params = this.getParamsList(transactionId);
            String checksumHeaderValue = this.checksumGenerator.getChecksumValue(null, httpUrl.encodedPath(), params, apiKey, keyIndex);
            List<HttpHeaderPair> httpHeaders = HttpUtils.getHttpHeaders(checksumHeaderValue);
            Callable<PhonePeHttpResponse<TransactionStatusResponse>> transactionStatusCallable = this.getCallable(httpUrl, httpHeaders);
            Predicate<PhonePeHttpResponse<TransactionStatusResponse>> phonePeHttpResponsePredicate = this.getRetryPredicate();
            Retryer<PhonePeHttpResponse<TransactionStatusResponse>> retryer = RetryUtils.getRetryer(this.statusConfig.getRetryConfig(), phonePeHttpResponsePredicate);
            PhonePeHttpResponse phonePeHttpResponse = (PhonePeHttpResponse)retryer.call(transactionStatusCallable);
            return this.buildStatusResponse(phonePeHttpResponse);
        }
        catch (RetryException ex) {
            PhonePeHttpResponse phonePeHttpResponse = (PhonePeHttpResponse)ex.getLastFailedAttempt().getResult();
            return this.buildStatusResponse(phonePeHttpResponse);
        }
        catch (Exception ex) {
            log.error("Exception occurred while performing transaction status check");
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("MESSAGE", ex.getMessage());
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.EXECUTION_ERROR, "Error executing check transaction status: " + ex.getMessage(), objectMap, ex);
        }
    }

    private List<String> getParamsList(String transactionId) {
        ArrayList<String> paramsList = new ArrayList<String>();
        paramsList.add(this.merchantConfig.getMerchantId());
        paramsList.add(transactionId);
        return paramsList;
    }

    private HttpUrl getHttpUrl(String transactionId) {
        return this.urlCreator.getHttpUrl(ConfigType.STATUS, this.statusConfig.getOverrideHost(), this.statusConfig.getApiVersion().getValue(), this.merchantConfig.getMerchantId(), transactionId);
    }

    private Callable<PhonePeHttpResponse<TransactionStatusResponse>> getCallable(final HttpUrl httpUrl, final List<HttpHeaderPair> headerPairs) {
        return new Callable<PhonePeHttpResponse<TransactionStatusResponse>>(){

            @Override
            public PhonePeHttpResponse<TransactionStatusResponse> call() throws Exception {
                return TransactionStatusChecker.this.transactionCommand.getTransactionStatus(headerPairs, httpUrl);
            }
        };
    }

    private Predicate<PhonePeHttpResponse<TransactionStatusResponse>> getRetryPredicate() {
        return new Predicate<PhonePeHttpResponse<TransactionStatusResponse>>(){

            public boolean apply(PhonePeHttpResponse<TransactionStatusResponse> transactionStatusResponse) {
                TransactionStatusCode code = (TransactionStatusCode)((Object)Enums.getIfPresent(TransactionStatusCode.class, (String)transactionStatusResponse.getCode()).or((Object)TransactionStatusCode.UNKNOWN));
                return TransactionStatusCode.PAYMENT_PENDING == code || TransactionStatusCode.INTERNAL_SERVER_ERROR == code;
            }
        };
    }

    private StatusResponse buildStatusResponse(PhonePeHttpResponse<TransactionStatusResponse> transactionStatusResponse) throws PhonePeClientException {
        return StatusResponse.builder().transactionId(transactionStatusResponse.getData().getTransactionId()).paymentState(this.getPaymentState(transactionStatusResponse.getCode())).providerReferenceId(transactionStatusResponse.getData().getProviderReferenceId()).amount(transactionStatusResponse.getData().getAmount()).paidAmount(transactionStatusResponse.getData().getPaidAmount()).paymentModes(transactionStatusResponse.getData().getPaymentModes()).build();
    }

    private PaymentState getPaymentState(String statusCode) throws PhonePeClientException {
        TransactionStatusCode code = (TransactionStatusCode)((Object)Enums.getIfPresent(TransactionStatusCode.class, (String)statusCode).or((Object)TransactionStatusCode.UNKNOWN));
        return code.accept(this.paymentStateCreator);
    }

    public static TransactionStatusCheckerBuilder builder() {
        return new TransactionStatusCheckerBuilder();
    }

    public ChecksumGenerator getChecksumGenerator() {
        return this.checksumGenerator;
    }

    public static class TransactionStatusCheckerBuilder {
        private TransactionCommand transactionCommand;
        private MerchantConfig merchantConfig;
        private StatusConfig statusConfig;
        private ChecksumGenerator checksumGenerator;
        private PaymentStateCreator paymentStateCreator;
        private URLCreator urlCreator;

        TransactionStatusCheckerBuilder() {
        }

        public TransactionStatusCheckerBuilder transactionCommand(TransactionCommand transactionCommand) {
            this.transactionCommand = transactionCommand;
            return this;
        }

        public TransactionStatusCheckerBuilder merchantConfig(MerchantConfig merchantConfig) {
            this.merchantConfig = merchantConfig;
            return this;
        }

        public TransactionStatusCheckerBuilder statusConfig(StatusConfig statusConfig) {
            this.statusConfig = statusConfig;
            return this;
        }

        public TransactionStatusCheckerBuilder checksumGenerator(ChecksumGenerator checksumGenerator) {
            this.checksumGenerator = checksumGenerator;
            return this;
        }

        public TransactionStatusCheckerBuilder paymentStateCreator(PaymentStateCreator paymentStateCreator) {
            this.paymentStateCreator = paymentStateCreator;
            return this;
        }

        public TransactionStatusCheckerBuilder urlCreator(URLCreator urlCreator) {
            this.urlCreator = urlCreator;
            return this;
        }

        public TransactionStatusChecker build() {
            return new TransactionStatusChecker(this.transactionCommand, this.merchantConfig, this.statusConfig, this.checksumGenerator, this.paymentStateCreator, this.urlCreator);
        }

        public String toString() {
            return "TransactionStatusChecker.TransactionStatusCheckerBuilder(transactionCommand=" + this.transactionCommand + ", merchantConfig=" + this.merchantConfig + ", statusConfig=" + this.statusConfig + ", checksumGenerator=" + this.checksumGenerator + ", paymentStateCreator=" + this.paymentStateCreator + ", urlCreator=" + this.urlCreator + ")";
        }
    }
}

