/*
 * Decompiled with CFR 0.152.
 */
package com.phronemophobic.cljcef;

import com.phronemophobic.cljcef.CefBaseRefCounted;
import com.sun.jna.Pointer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ReferenceCountImpl {
    static ConcurrentHashMap<Pointer, AtomicInteger> notGarbage = new ConcurrentHashMap();

    public static void track(Pointer pointer) {
        CefBaseRefCounted cefBaseRefCounted = (CefBaseRefCounted)CefBaseRefCounted.newInstance(CefBaseRefCounted.class, (Pointer)pointer);
        cefBaseRefCounted.add_ref = new CefBaseRefCounted.AddRefFunc(){

            @Override
            public void add_ref(Pointer pointer) {
                AtomicInteger atomicInteger = notGarbage.get(pointer);
                if (atomicInteger != null) {
                    atomicInteger.incrementAndGet();
                } else {
                    System.err.println("Phantom retain! " + pointer);
                }
            }
        };
        cefBaseRefCounted.release = new CefBaseRefCounted.ReleaseFunc(){

            @Override
            public int release(Pointer pointer) {
                AtomicInteger atomicInteger = notGarbage.get(pointer);
                if (atomicInteger != null) {
                    boolean bl;
                    int n = atomicInteger.decrementAndGet();
                    boolean bl2 = bl = n == 0;
                    if (bl) {
                        notGarbage.remove(pointer);
                        return 1;
                    }
                    return 0;
                }
                System.err.println("Phantom release! " + pointer);
                return 0;
            }
        };
        cefBaseRefCounted.has_one_ref = new CefBaseRefCounted.HasOneRefFunc(){

            @Override
            public int has_one_ref(Pointer pointer) {
                AtomicInteger atomicInteger = notGarbage.get(pointer);
                if (atomicInteger != null) {
                    int n = atomicInteger.get();
                    if (n == 1) {
                        return 1;
                    }
                    return 0;
                }
                System.err.println("Phantom has_one_ref! " + pointer);
                return 0;
            }
        };
        cefBaseRefCounted.has_at_least_one_ref = new CefBaseRefCounted.HasAtLeastOneRefFunc(){

            @Override
            public int has_at_least_one_ref(Pointer pointer) {
                AtomicInteger atomicInteger = notGarbage.get(pointer);
                if (atomicInteger != null) {
                    int n = atomicInteger.get();
                    if (n >= 1) {
                        return 1;
                    }
                    return 0;
                }
                System.err.println("Phantom has_one_ref! " + pointer);
                return 0;
            }
        };
        notGarbage.put(pointer, new AtomicInteger(1));
    }
}

