/*
 * Decompiled with CFR 0.152.
 */
package com.platform.callback;

import com.codahale.metrics.MetricRegistry;
import com.collections.CollectionUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hystrix.configurator.config.HystrixConfig;
import com.hystrix.configurator.core.HystrixConfigurationFactory;
import com.phonepe.rosey.dwconfig.RoseyConfigSourceProvider;
import com.platform.callback.AppConfig;
import com.platform.callback.rabbitmq.ActionMessagePublisher;
import com.platform.callback.rabbitmq.RMQWrapper;
import com.platform.callback.rabbitmq.actors.impl.CallbackMessageHandlingActor;
import com.platform.callback.resources.CallbackRequestResource;
import io.dropwizard.Application;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.actors.RabbitmqActorBundle;
import io.dropwizard.actors.actor.ActorConfig;
import io.dropwizard.actors.config.RMQConfig;
import io.dropwizard.actors.connectivity.RMQConnection;
import io.dropwizard.checkmate.CheckmateBundle;
import io.dropwizard.checkmate.model.CheckmateBundleConfiguration;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.EnvironmentVariableSubstitutor;
import io.dropwizard.configuration.SubstitutingSourceProvider;
import io.dropwizard.discovery.bundle.ServiceDiscoveryBundle;
import io.dropwizard.discovery.bundle.ServiceDiscoveryConfiguration;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.oor.OorBundle;
import io.dropwizard.primer.PrimerBundle;
import io.dropwizard.primer.model.PrimerAuthorization;
import io.dropwizard.primer.model.PrimerAuthorizationMatrix;
import io.dropwizard.primer.model.PrimerBundleConfiguration;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.aeroapike.AerospikeConnectionManager;
import io.dropwizard.revolver.callback.InlineCallbackHandler;
import io.dropwizard.revolver.core.config.AerospikeMailBoxConfig;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.filters.RevolverRequestFilter;
import io.dropwizard.revolver.handler.ConfigSource;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.dropwizard.revolver.persistence.AeroSpikePersistenceProvider;
import io.dropwizard.revolver.persistence.InMemoryPersistenceProvider;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import io.dropwizard.riemann.RiemannBundle;
import io.dropwizard.riemann.RiemannConfig;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.text.StrSubstitutor;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App
extends Application<AppConfig> {
    private static final Logger log = LoggerFactory.getLogger(App.class);

    public void initialize(Bootstrap<AppConfig> bootstrap) {
        boolean localConfig;
        bootstrap.addBundle((ConfiguredBundle)new OorBundle<AppConfig>(){

            public boolean withOor() {
                return false;
            }
        });
        SubstitutingSourceProvider configurationSourceProvider = new SubstitutingSourceProvider(bootstrap.getConfigurationSourceProvider(), (StrSubstitutor)new EnvironmentVariableSubstitutor());
        String localConfigStr = System.getenv("localConfig");
        boolean bl = localConfig = !Strings.isNullOrEmpty((String)localConfigStr) && Boolean.parseBoolean(localConfigStr);
        if (localConfig) {
            bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new SubstitutingSourceProvider(bootstrap.getConfigurationSourceProvider(), (StrSubstitutor)new EnvironmentVariableSubstitutor()));
        } else {
            bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new SubstitutingSourceProvider((ConfigurationSourceProvider)new RoseyConfigSourceProvider("callback", "callback"), (StrSubstitutor)new EnvironmentVariableSubstitutor()));
        }
        ServiceDiscoveryBundle<AppConfig> serviceDiscoveryBundle = new ServiceDiscoveryBundle<AppConfig>(){

            protected ServiceDiscoveryConfiguration getRangerConfiguration(AppConfig configuration) {
                return configuration.getDiscovery();
            }

            protected String getServiceName(AppConfig configuration) {
                return configuration.getAppName();
            }

            protected int getPort(AppConfig configuration) {
                return configuration.getDiscovery().getPublishedPort();
            }
        };
        bootstrap.addBundle((ConfiguredBundle)serviceDiscoveryBundle);
        bootstrap.addBundle((ConfiguredBundle)new RevolverBundle<AppConfig>((ServiceDiscoveryBundle)serviceDiscoveryBundle, (ConfigurationSourceProvider)configurationSourceProvider){
            final /* synthetic */ ServiceDiscoveryBundle val$serviceDiscoveryBundle;
            final /* synthetic */ ConfigurationSourceProvider val$configurationSourceProvider;
            {
                this.val$serviceDiscoveryBundle = serviceDiscoveryBundle;
                this.val$configurationSourceProvider = configurationSourceProvider;
            }

            public CuratorFramework getCurator() {
                return this.val$serviceDiscoveryBundle.getCurator();
            }

            public RevolverConfig getRevolverConfig(AppConfig appConfig) {
                return appConfig.getRevolver();
            }

            public String getRevolverConfigAttribute() {
                return "revolver";
            }

            public ConfigSource getConfigSource() {
                return () -> {
                    try {
                        return this.val$configurationSourceProvider.open("config/local.yml");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                };
            }
        });
        bootstrap.addBundle((ConfiguredBundle)new PrimerBundle<AppConfig>((ServiceDiscoveryBundle)serviceDiscoveryBundle){
            final /* synthetic */ ServiceDiscoveryBundle val$serviceDiscoveryBundle;
            {
                this.val$serviceDiscoveryBundle = serviceDiscoveryBundle;
            }

            public CuratorFramework getCurator(AppConfig configuration) {
                return this.val$serviceDiscoveryBundle.getCurator();
            }

            public PrimerBundleConfiguration getPrimerConfiguration(AppConfig apiConfiguration) {
                return apiConfiguration.getPrimer();
            }

            public Set<String> withWhiteList(AppConfig apiConfiguration) {
                return apiConfiguration.getRevolver().getServices().stream().filter(service -> service instanceof RevolverHttpServiceConfig).map(service -> ((RevolverHttpServiceConfig)service).getApis().stream().filter(RevolverHttpApiConfig::isWhitelist).map(a -> "apis/" + service.getService() + "/" + a.getPath()).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
            }

            public PrimerAuthorizationMatrix withAuthorization(AppConfig apiConfiguration) {
                List staticAuth = apiConfiguration.getRevolver().getServices().stream().filter(service -> service instanceof RevolverHttpServiceConfig).map(service -> ((RevolverHttpServiceConfig)service).getApis().stream().filter(a -> !a.isWhitelist()).filter(this::checkStaticAuthorization).map(a -> this.primerStaticAuthorization((RevolverHttpApiConfig)a, (RevolverHttpServiceConfig)service)).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toList());
                List dynamicAuth = apiConfiguration.getRevolver().getServices().stream().filter(service -> service instanceof RevolverHttpServiceConfig).map(service -> ((RevolverHttpServiceConfig)service).getApis().stream().filter(a -> !a.isWhitelist()).filter(this::checkDynamicAuthorization).map(a -> this.primerDynamicAuthorization((RevolverHttpApiConfig)a, (RevolverHttpServiceConfig)service)).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toList());
                List autoAuth = apiConfiguration.getRevolver().getServices().stream().filter(service -> service instanceof RevolverHttpServiceConfig).map(service -> ((RevolverHttpServiceConfig)service).getApis().stream().filter(a -> !a.isWhitelist()).filter(this::checkAutoAuthorization).map(a -> this.primerAutoAuthorization((RevolverHttpApiConfig)a, (RevolverHttpServiceConfig)service)).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toList());
                if (apiConfiguration.getPrimer() != null && apiConfiguration.getPrimer().getAuthorizations() != null) {
                    if (apiConfiguration.getPrimer().getAuthorizations().getAutoAuthorizations() != null) {
                        autoAuth.addAll(apiConfiguration.getPrimer().getAuthorizations().getAutoAuthorizations());
                    }
                    if (apiConfiguration.getPrimer().getAuthorizations().getStaticAuthorizations() != null) {
                        autoAuth.addAll(apiConfiguration.getPrimer().getAuthorizations().getStaticAuthorizations());
                    }
                    if (apiConfiguration.getPrimer().getAuthorizations().getAuthorizations() != null) {
                        dynamicAuth.addAll(apiConfiguration.getPrimer().getAuthorizations().getAuthorizations());
                    }
                }
                return PrimerAuthorizationMatrix.builder().staticAuthorizations(staticAuth).authorizations(dynamicAuth).autoAuthorizations(autoAuth).build();
            }

            private PrimerAuthorization primerDynamicAuthorization(RevolverHttpApiConfig apiConfig, RevolverHttpServiceConfig serviceConfig) {
                return PrimerAuthorization.builder().type("dynamic").url("apis/" + serviceConfig.getService() + "/" + apiConfig.getPath()).methods((Collection)apiConfig.getAuthorization().getMethods()).roles((Collection)apiConfig.getAuthorization().getRoles()).build();
            }

            private boolean checkDynamicAuthorization(RevolverHttpApiConfig apiConfig) {
                return !apiConfig.isWhitelist() && apiConfig.getAuthorization() != null && apiConfig.getAuthorization().getType().equals("dynamic");
            }

            private PrimerAuthorization primerStaticAuthorization(RevolverHttpApiConfig apiConfig, RevolverHttpServiceConfig serviceConfig) {
                return PrimerAuthorization.builder().type("static").url("apis/" + serviceConfig.getService() + "/" + apiConfig.getPath()).methods((Collection)apiConfig.getAuthorization().getMethods()).roles((Collection)apiConfig.getAuthorization().getRoles()).build();
            }

            private boolean checkStaticAuthorization(RevolverHttpApiConfig apiConfig) {
                return !apiConfig.isWhitelist() && apiConfig.getAuthorization() != null && apiConfig.getAuthorization().getType().equals("static");
            }

            private PrimerAuthorization primerAutoAuthorization(RevolverHttpApiConfig apiConfig, RevolverHttpServiceConfig serviceConfig) {
                return PrimerAuthorization.builder().type("auto").url("apis/" + serviceConfig.getService() + "/" + apiConfig.getPath()).methods((Collection)apiConfig.getAuthorization().getMethods()).roles((Collection)apiConfig.getAuthorization().getRoles()).build();
            }

            private boolean checkAutoAuthorization(RevolverHttpApiConfig apiConfig) {
                return !apiConfig.isWhitelist() && apiConfig.getAuthorization() != null && apiConfig.getAuthorization().getType().equals("auto");
            }
        });
        RabbitmqActorBundle<AppConfig> rabbitmqActorBundle = new RabbitmqActorBundle<AppConfig>(){

            protected RMQConfig getConfig(AppConfig appConfig) {
                return appConfig.getRmqConfig();
            }
        };
        bootstrap.addBundle((ConfiguredBundle)rabbitmqActorBundle);
        bootstrap.addBundle((ConfiguredBundle)new RiemannBundle<AppConfig>(){

            public RiemannConfig getRiemannConfiguration(AppConfig configuration) {
                return configuration.getRiemann();
            }
        });
        bootstrap.addBundle((ConfiguredBundle)new CheckmateBundle<AppConfig>(serviceDiscoveryBundle.getCurator()){

            public CheckmateBundleConfiguration getCheckmateConfiguration(AppConfig apiConfiguration) {
                return apiConfiguration.getCheckmate();
            }
        });
    }

    public void run(AppConfig configuration, Environment environment) throws Exception {
        String executionEnv = System.getenv("CONFIG_ENV");
        ObjectMapper objectMapper = environment.getObjectMapper();
        MetricRegistry metrics = environment.metrics();
        log.info("InitializedManagedObject type: rabbitMqConnection");
        HystrixConfigurationFactory.init((HystrixConfig)configuration.getHystrixConfig());
        PersistenceProvider persistenceProvider = this.getPersistenceProvider(configuration, environment);
        InlineCallbackHandler callbackHandler = InlineCallbackHandler.builder().persistenceProvider(persistenceProvider).revolverConfig(configuration.getRevolver()).build();
        environment.jersey().register((Object)new RevolverRequestFilter(configuration.getRevolver()));
        ArrayList messageHandlingActorList = Lists.newArrayList();
        Map<String, ActorConfig> actors = this.getActors(configuration);
        AtomicInteger rmqConcurrency = new AtomicInteger();
        actors.forEach((a, actorConfig) -> rmqConcurrency.addAndGet(actorConfig.getConcurrency()));
        RMQConnection rmqConnection = new RMQConnection(configuration.getRmqConfig(), metrics, Executors.newFixedThreadPool(rmqConcurrency.get()));
        environment.lifecycle().manage((Managed)rmqConnection);
        actors.forEach((a, actorConfig) -> messageHandlingActorList.add(new CallbackMessageHandlingActor((String)a, (ActorConfig)actorConfig, rmqConnection, objectMapper, callbackHandler, persistenceProvider)));
        ActionMessagePublisher.initialize(messageHandlingActorList);
        CallbackRequestResource callbackRequestResource = CallbackRequestResource.builder().callbackHandler(callbackHandler).jsonObjectMapper(objectMapper).persistenceProvider(persistenceProvider).msgPackObjectMapper(objectMapper).build();
        environment.lifecycle().manage((Managed)new RMQWrapper(rmqConnection));
        environment.jersey().register((Object)callbackRequestResource);
    }

    private Map<String, ActorConfig> getActors(AppConfig configuration) {
        HashMap actors = Maps.newHashMap();
        for (RevolverServiceConfig revolverServiceConfig : configuration.getRevolver().getServices()) {
            actors.putAll(CollectionUtils.nullSafeMap((Map)revolverServiceConfig.getActors()));
        }
        return actors;
    }

    private PersistenceProvider getPersistenceProvider(AppConfig configuration, Environment environment) {
        RevolverConfig revolverConfig = configuration.getRevolver();
        if (revolverConfig.getMailBox() == null) {
            return new InMemoryPersistenceProvider();
        }
        switch (revolverConfig.getMailBox().getType()) {
            case "in_memory": {
                return new InMemoryPersistenceProvider();
            }
            case "aerospike": {
                AerospikeConnectionManager.init((AerospikeMailBoxConfig)((AerospikeMailBoxConfig)revolverConfig.getMailBox()));
                return new AeroSpikePersistenceProvider((AerospikeMailBoxConfig)revolverConfig.getMailBox(), environment.getObjectMapper());
            }
        }
        throw new IllegalArgumentException("Invalid mailbox configuration");
    }
}

