/*
 * Decompiled with CFR 0.152.
 */
package com.platform.callback.rabbitmq.actors.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.platform.callback.rabbitmq.actors.messages.ActionMessage;
import io.dropwizard.actors.actor.ActorConfig;
import io.dropwizard.actors.actor.UnmanagedBaseActor;
import io.dropwizard.actors.connectivity.RMQConnection;
import io.dropwizard.actors.retry.RetryStrategyFactory;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageHandlingActor {
    private static final Logger log = LoggerFactory.getLogger(MessageHandlingActor.class);
    private static final Set<Class<? extends Exception>> IGNORABLE_EXCEPTIONS = ImmutableSet.of(JsonProcessingException.class);
    private final UnmanagedBaseActor<ActionMessage> actorImpl;
    private final String queueId;

    @Inject
    public MessageHandlingActor(String queueId, ActorConfig config, RMQConnection connection, ObjectMapper mapper) {
        this.actorImpl = new UnmanagedBaseActor(queueId, config, connection, mapper, new RetryStrategyFactory(), ActionMessage.class, this::handle, t -> IGNORABLE_EXCEPTIONS.stream().anyMatch(exceptionType -> ClassUtils.isAssignable(t.getClass(), (Class)exceptionType)));
        log.info("Created actor implementation for {}", (Object)queueId);
        this.queueId = queueId;
    }

    public <Message extends ActionMessage> void publish(Message message) throws Exception {
        this.actorImpl.publish(message);
    }

    public void start() throws Exception {
        this.actorImpl.start();
    }

    public void stop() throws Exception {
        this.actorImpl.stop();
    }

    public abstract <Message extends ActionMessage> boolean handle(Message var1);

    public UnmanagedBaseActor<ActionMessage> getActorImpl() {
        return this.actorImpl;
    }

    public String getQueueId() {
        return this.queueId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageHandlingActor)) {
            return false;
        }
        MessageHandlingActor other = (MessageHandlingActor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UnmanagedBaseActor<ActionMessage> this$actorImpl = this.getActorImpl();
        UnmanagedBaseActor<ActionMessage> other$actorImpl = other.getActorImpl();
        if (this$actorImpl == null ? other$actorImpl != null : !this$actorImpl.equals(other$actorImpl)) {
            return false;
        }
        String this$queueId = this.getQueueId();
        String other$queueId = other.getQueueId();
        return !(this$queueId == null ? other$queueId != null : !this$queueId.equals(other$queueId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageHandlingActor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UnmanagedBaseActor<ActionMessage> $actorImpl = this.getActorImpl();
        result = result * 59 + ($actorImpl == null ? 43 : $actorImpl.hashCode());
        String $queueId = this.getQueueId();
        result = result * 59 + ($queueId == null ? 43 : $queueId.hashCode());
        return result;
    }

    public String toString() {
        return "MessageHandlingActor(actorImpl=" + this.getActorImpl() + ", queueId=" + this.getQueueId() + ")";
    }
}

