/*
 * Decompiled with CFR 0.152.
 */
package com.platform.callback.resources;

import com.codahale.metrics.annotation.Metered;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.platform.callback.rabbitmq.ActionMessagePublisher;
import com.platform.callback.rabbitmq.actors.messages.CallbackMessage;
import io.dropwizard.jersey.PATCH;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.base.core.RevolverAckMessage;
import io.dropwizard.revolver.base.core.RevolverCallbackRequest;
import io.dropwizard.revolver.base.core.RevolverCallbackResponse;
import io.dropwizard.revolver.base.core.RevolverRequestState;
import io.dropwizard.revolver.callback.InlineCallbackHandler;
import io.dropwizard.revolver.core.model.RevolverRequest;
import io.dropwizard.revolver.core.tracing.TraceInfo;
import io.dropwizard.revolver.http.RevolverHttpCommand;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.model.ApiPathMap;
import io.dropwizard.revolver.http.model.RevolverHttpRequest;
import io.dropwizard.revolver.http.model.RevolverHttpResponse;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import io.dropwizard.revolver.util.ResponseTransformationUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/apis")
@Singleton
@Api(value="Revolver Gateway", description="Revolver api gateway endpoints")
public class CallbackRequestResource {
    private static final Logger log = LoggerFactory.getLogger(CallbackRequestResource.class);
    private static final Map<String, String> BAD_REQUEST_RESPONSE = Collections.singletonMap("message", "Bad Request");
    private static final Map<String, String> DUPLICATE_REQUEST_RESPONSE = Collections.singletonMap("message", "Duplicate");
    private static Map<String, String> SERVICE_UNAVAILABLE_RESPONSE = Collections.singletonMap("message", "Service Unavailable");
    private final ObjectMapper jsonObjectMapper;
    private final ObjectMapper msgPackObjectMapper;
    private final PersistenceProvider persistenceProvider;
    private final InlineCallbackHandler callbackHandler;

    public CallbackRequestResource(ObjectMapper jsonObjectMapper, ObjectMapper msgPackObjectMapper, PersistenceProvider persistenceProvider, InlineCallbackHandler callbackHandler) {
        this.jsonObjectMapper = jsonObjectMapper;
        this.msgPackObjectMapper = msgPackObjectMapper;
        this.persistenceProvider = persistenceProvider;
        this.callbackHandler = callbackHandler;
    }

    @GET
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver GET api endpoint")
    public Response get(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo) throws Exception {
        return this.processRequest(service, RevolverHttpApiConfig.RequestMethod.GET, path, headers, uriInfo, null);
    }

    @HEAD
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver HEAD api endpoint")
    public Response head(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo) throws Exception {
        return this.processRequest(service, RevolverHttpApiConfig.RequestMethod.HEAD, path, headers, uriInfo, null);
    }

    @POST
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver POST api endpoint")
    public Response post(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, byte[] body) throws Exception {
        return this.processRequest(service, RevolverHttpApiConfig.RequestMethod.POST, path, headers, uriInfo, body);
    }

    @PUT
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver PUT api endpoint")
    public Response put(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, byte[] body) throws Exception {
        return this.processRequest(service, RevolverHttpApiConfig.RequestMethod.PUT, path, headers, uriInfo, body);
    }

    @DELETE
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver DELETE api endpoint")
    public Response delete(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo) throws Exception {
        return this.processRequest(service, RevolverHttpApiConfig.RequestMethod.DELETE, path, headers, uriInfo, null);
    }

    @PATCH
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver PATCH api endpoint")
    public Response patch(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, byte[] body) throws Exception {
        return this.processRequest(service, RevolverHttpApiConfig.RequestMethod.PATCH, path, headers, uriInfo, body);
    }

    @OPTIONS
    @Path(value="/{service}/{path: .*}")
    @Metered
    @ApiOperation(value="Revolver OPTIONS api endpoint")
    public Response options(@PathParam(value="service") String service, @PathParam(value="path") String path, @Context HttpHeaders headers, @Context UriInfo uriInfo, byte[] body) throws Exception {
        return this.processRequest(service, RevolverHttpApiConfig.RequestMethod.OPTIONS, path, headers, uriInfo, body);
    }

    private Response processRequest(String service, RevolverHttpApiConfig.RequestMethod method, String path, HttpHeaders headers, UriInfo uriInfo, byte[] body) throws Exception {
        ApiPathMap apiMap = RevolverBundle.matchPath((String)service, (String)path);
        if (apiMap == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ResponseTransformationUtil.transform(BAD_REQUEST_RESPONSE, (String)(headers.getMediaType() != null ? headers.getMediaType().toString() : "application/json"), (ObjectMapper)this.jsonObjectMapper, (ObjectMapper)this.msgPackObjectMapper)).build();
        }
        String serviceKey = service + "." + apiMap.getApi().getApi();
        if (RevolverBundle.apiStatus.containsKey(serviceKey) && !((Boolean)RevolverBundle.apiStatus.get(serviceKey)).booleanValue()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)ResponseTransformationUtil.transform(SERVICE_UNAVAILABLE_RESPONSE, (String)(headers.getMediaType() != null ? headers.getMediaType().toString() : "application/json"), (ObjectMapper)this.jsonObjectMapper, (ObjectMapper)this.msgPackObjectMapper)).build();
        }
        String callMode = (String)headers.getRequestHeaders().getFirst((Object)"X-CALL-MODE");
        if (callMode == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ResponseTransformationUtil.transform(BAD_REQUEST_RESPONSE, (String)(headers.getMediaType() != null ? headers.getMediaType().toString() : "application/json"), (ObjectMapper)this.jsonObjectMapper, (ObjectMapper)this.msgPackObjectMapper)).build();
        }
        switch (callMode.toUpperCase()) {
            case "CALLBACK": {
                if (Strings.isNullOrEmpty((String)headers.getHeaderString("X-CALLBACK-URI"))) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ResponseTransformationUtil.transform(BAD_REQUEST_RESPONSE, (String)(headers.getMediaType() != null ? headers.getMediaType().toString() : "application/json"), (ObjectMapper)this.jsonObjectMapper, (ObjectMapper)this.msgPackObjectMapper)).build();
                }
                return this.executeCommandAsync(service, apiMap.getApi(), method, path, headers, uriInfo, body, apiMap.getApi().isAsync(), callMode);
            }
            case "CALLBACK_SYNC": {
                if (Strings.isNullOrEmpty((String)headers.getHeaderString("X-CALLBACK-URI"))) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ResponseTransformationUtil.transform(BAD_REQUEST_RESPONSE, (String)(headers.getMediaType() != null ? headers.getMediaType().toString() : "application/json"), (ObjectMapper)this.jsonObjectMapper, (ObjectMapper)this.msgPackObjectMapper)).build();
                }
                return this.executeCallbackSync(service, apiMap.getApi(), method, path, headers, uriInfo, body);
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ResponseTransformationUtil.transform(BAD_REQUEST_RESPONSE, (String)(headers.getMediaType() != null ? headers.getMediaType().toString() : "application/json"), (ObjectMapper)this.jsonObjectMapper, (ObjectMapper)this.msgPackObjectMapper)).build();
    }

    private Response transform(HttpHeaders headers, RevolverHttpResponse response, String api, String path, RevolverHttpApiConfig.RequestMethod method) throws IOException {
        String requestMediaType;
        Response.ResponseBuilder httpResponse = Response.status((int)response.getStatusCode());
        if (response.getHeaders() != null) {
            response.getHeaders().keySet().stream().filter(h -> !h.equalsIgnoreCase("Content-Type")).filter(h -> !h.equalsIgnoreCase("Content-Length")).forEach(h -> httpResponse.header(h, response.getHeaders().getFirst(h)));
        }
        httpResponse.header("X-REQUESTED-PATH", (Object)path);
        httpResponse.header("X-REQUESTED-METHOD", (Object)method);
        httpResponse.header("X-REQUESTED-API", (Object)api);
        String responseMediaType = response.getHeaders() != null && Strings.isNullOrEmpty((String)((String)response.getHeaders().getFirst((Object)"Content-Type"))) ? "text/html" : (String)response.getHeaders().getFirst((Object)"Content-Type");
        String string = requestMediaType = headers != null && Strings.isNullOrEmpty((String)headers.getHeaderString("Accept")) ? null : headers.getHeaderString("Accept");
        if (Strings.isNullOrEmpty((String)requestMediaType) || requestMediaType.equals(responseMediaType)) {
            httpResponse.header("Content-Type", (Object)responseMediaType);
            httpResponse.entity((Object)response.getBody());
            return httpResponse.build();
        }
        Object responseData = null;
        if (responseMediaType.startsWith("application/json")) {
            JsonNode jsonNode = this.jsonObjectMapper.readTree(response.getBody());
            responseData = jsonNode.isArray() ? this.jsonObjectMapper.convertValue((Object)jsonNode, List.class) : this.jsonObjectMapper.convertValue((Object)jsonNode, Map.class);
        } else if (responseMediaType.startsWith("application/msgpack")) {
            JsonNode jsonNode = this.msgPackObjectMapper.readTree(response.getBody());
            responseData = jsonNode.isArray() ? this.msgPackObjectMapper.convertValue((Object)jsonNode, List.class) : this.msgPackObjectMapper.convertValue((Object)jsonNode, Map.class);
        }
        if (responseData == null) {
            httpResponse.entity((Object)response.getBody());
        } else if (requestMediaType.startsWith("application/json")) {
            httpResponse.header("Content-Type", (Object)"application/json");
            httpResponse.entity((Object)this.jsonObjectMapper.writeValueAsBytes(responseData));
        } else if (requestMediaType.startsWith("application/msgpack")) {
            httpResponse.header("Content-Type", (Object)"application/msgpack");
            httpResponse.entity((Object)this.msgPackObjectMapper.writeValueAsBytes(responseData));
        } else {
            httpResponse.header("Content-Type", (Object)"application/json");
            httpResponse.entity((Object)this.jsonObjectMapper.writeValueAsBytes(responseData));
        }
        return httpResponse.build();
    }

    private void cleanHeaders(MultivaluedMap<String, String> headers, RevolverHttpApiConfig apiConfig) {
        headers.remove((Object)"Host");
        headers.remove((Object)"Accept");
        headers.remove((Object)"Accept-Encoding");
        headers.putSingle((Object)"Accept", (Object)apiConfig.getAcceptType());
        headers.putSingle((Object)"Accept-Encoding", (Object)apiConfig.getAcceptEncoding());
    }

    private Response executeCommandAsync(String service, RevolverHttpApiConfig api, RevolverHttpApiConfig.RequestMethod method, String path, HttpHeaders headers, UriInfo uriInfo, byte[] body, boolean isDownstreamAsync, String callMode) throws Exception {
        int mailBoxTtl;
        MultivaluedHashMap sanatizedHeaders = new MultivaluedHashMap();
        headers.getRequestHeaders().forEach((arg_0, arg_1) -> ((MultivaluedHashMap)sanatizedHeaders).put(arg_0, arg_1));
        this.cleanHeaders((MultivaluedMap<String, String>)sanatizedHeaders, api);
        RevolverHttpCommand httpCommand = RevolverBundle.getHttpCommand((String)service, (String)api.getApi());
        String requestId = headers.getHeaderString("X-REQUEST-ID");
        String transactionId = headers.getHeaderString("X-TRANSACTION-ID");
        String mailBoxId = headers.getHeaderString("X-MAILBOX-ID");
        int n = mailBoxTtl = headers.getHeaderString("X-MAILBOX-TTL") != null ? Integer.parseInt(headers.getHeaderString("X-MAILBOX-TTL")) : -1;
        if (this.persistenceProvider.exists(requestId)) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)ResponseTransformationUtil.transform(DUPLICATE_REQUEST_RESPONSE, (String)(headers.getMediaType() == null ? "application/json" : headers.getMediaType().toString()), (ObjectMapper)this.jsonObjectMapper, (ObjectMapper)this.msgPackObjectMapper)).build();
        }
        this.persistenceProvider.saveRequest(requestId, mailBoxId, RevolverCallbackRequest.builder().api(api.getApi()).mode((String)headers.getRequestHeaders().getFirst((Object)"X-CALL-MODE")).callbackUri((String)headers.getRequestHeaders().getFirst((Object)"X-CALLBACK-URI")).method((String)headers.getRequestHeaders().getFirst((Object)"X-CALLBACK-METHOD")).service(service).path(path).headers((Map)headers.getRequestHeaders()).queryParams((Map)uriInfo.getQueryParameters()).body(body).build(), mailBoxTtl);
        CompletableFuture response = httpCommand.executeAsync((RevolverRequest)RevolverHttpRequest.builder().traceInfo(TraceInfo.builder().requestId(requestId).transactionId(transactionId).timestamp(System.currentTimeMillis()).build()).api(api.getApi()).service(service).path(path).method(method).headers((MultivaluedMap)sanatizedHeaders).queryParams(uriInfo.getQueryParameters()).body(body).build());
        if (isDownstreamAsync) {
            RevolverHttpResponse result2 = (RevolverHttpResponse)response.get();
            if (result2.getStatusCode() == Response.Status.ACCEPTED.getStatusCode()) {
                this.persistenceProvider.setRequestState(requestId, RevolverRequestState.REQUESTED, mailBoxTtl);
            } else {
                this.persistenceProvider.setRequestState(requestId, RevolverRequestState.RESPONDED, mailBoxTtl);
                this.saveResponse(requestId, result2, callMode, mailBoxTtl, api);
            }
            return this.transform(headers, result2, api.getApi(), path, method);
        }
        response.thenAcceptAsync(result -> {
            try {
                if (result.getStatusCode() == Response.Status.ACCEPTED.getStatusCode()) {
                    this.persistenceProvider.setRequestState(requestId, RevolverRequestState.REQUESTED, mailBoxTtl);
                } else if (result.getStatusCode() == Response.Status.OK.getStatusCode()) {
                    this.persistenceProvider.setRequestState(requestId, RevolverRequestState.RESPONDED, mailBoxTtl);
                    this.saveResponse(requestId, (RevolverHttpResponse)result, callMode, mailBoxTtl, api);
                } else {
                    this.persistenceProvider.setRequestState(requestId, RevolverRequestState.ERROR, mailBoxTtl);
                    this.saveResponse(requestId, (RevolverHttpResponse)result, callMode, mailBoxTtl, api);
                }
            }
            catch (Exception e) {
                log.error("Error setting request state for request id: {}", (Object)requestId, (Object)e);
            }
        });
        RevolverAckMessage revolverAckMessage = RevolverAckMessage.builder().requestId(requestId).acceptedAt(Instant.now().toEpochMilli()).build();
        return Response.accepted().entity((Object)ResponseTransformationUtil.transform((Object)revolverAckMessage, (String)(headers.getMediaType() == null ? "application/json" : headers.getMediaType().toString()), (ObjectMapper)this.jsonObjectMapper, (ObjectMapper)this.msgPackObjectMapper)).build();
    }

    private Response executeCallbackSync(String service, RevolverHttpApiConfig api, RevolverHttpApiConfig.RequestMethod method, String path, HttpHeaders headers, UriInfo uriInfo, byte[] body) throws Exception {
        int mailBoxTtl;
        MultivaluedHashMap sanatizedHeaders = new MultivaluedHashMap();
        headers.getRequestHeaders().forEach((arg_0, arg_1) -> ((MultivaluedHashMap)sanatizedHeaders).put(arg_0, arg_1));
        this.cleanHeaders((MultivaluedMap<String, String>)sanatizedHeaders, api);
        RevolverHttpCommand httpCommand = RevolverBundle.getHttpCommand((String)service, (String)api.getApi());
        String requestId = headers.getHeaderString("X-REQUEST-ID");
        String transactionId = headers.getHeaderString("X-TRANSACTION-ID");
        String mailBoxId = headers.getHeaderString("X-MAILBOX-ID");
        int n = mailBoxTtl = headers.getHeaderString("X-MAILBOX-TTL") != null ? Integer.parseInt(headers.getHeaderString("X-MAILBOX-TTL")) : -1;
        if (this.persistenceProvider.exists(requestId)) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)ResponseTransformationUtil.transform(DUPLICATE_REQUEST_RESPONSE, (String)(headers.getMediaType() == null ? "application/json" : headers.getMediaType().toString()), (ObjectMapper)this.jsonObjectMapper, (ObjectMapper)this.msgPackObjectMapper)).build();
        }
        this.persistenceProvider.saveRequest(requestId, mailBoxId, RevolverCallbackRequest.builder().api(api.getApi()).mode((String)headers.getRequestHeaders().getFirst((Object)"X-CALL-MODE")).callbackUri((String)headers.getRequestHeaders().getFirst((Object)"X-CALLBACK-URI")).method((String)headers.getRequestHeaders().getFirst((Object)"X-CALLBACK-METHOD")).service(service).path(path).headers((Map)headers.getRequestHeaders()).queryParams((Map)uriInfo.getQueryParameters()).body(body).build(), mailBoxTtl);
        CompletableFuture response = httpCommand.executeAsync((RevolverRequest)RevolverHttpRequest.builder().traceInfo(TraceInfo.builder().requestId(requestId).transactionId(transactionId).timestamp(System.currentTimeMillis()).build()).api(api.getApi()).service(service).path(path).method(method).headers((MultivaluedMap)sanatizedHeaders).queryParams(uriInfo.getQueryParameters()).body(body).build());
        RevolverHttpResponse result = (RevolverHttpResponse)response.get();
        this.persistenceProvider.setRequestState(requestId, RevolverRequestState.REQUESTED, mailBoxTtl);
        return this.transform(headers, result, api.getApi(), path, method);
    }

    private void saveResponse(String requestId, RevolverHttpResponse result, String callMode, int ttl, RevolverHttpApiConfig api) {
        try {
            RevolverCallbackResponse response = RevolverCallbackResponse.builder().body(result.getBody()).headers((Map)result.getHeaders()).statusCode(result.getStatusCode()).build();
            this.persistenceProvider.saveResponse(requestId, response, ttl);
            if (callMode != null && callMode.equals("CALLBACK")) {
                String queueId = api.getCallbackQueueId();
                ActionMessagePublisher.publish(CallbackMessage.builder().requestId(requestId).queueId(queueId).build());
            }
        }
        catch (Exception e) {
            log.error("Error saving response!", (Throwable)e);
        }
    }

    public static CallbackRequestResourceBuilder builder() {
        return new CallbackRequestResourceBuilder();
    }

    public static class CallbackRequestResourceBuilder {
        private ObjectMapper jsonObjectMapper;
        private ObjectMapper msgPackObjectMapper;
        private PersistenceProvider persistenceProvider;
        private InlineCallbackHandler callbackHandler;

        CallbackRequestResourceBuilder() {
        }

        public CallbackRequestResourceBuilder jsonObjectMapper(ObjectMapper jsonObjectMapper) {
            this.jsonObjectMapper = jsonObjectMapper;
            return this;
        }

        public CallbackRequestResourceBuilder msgPackObjectMapper(ObjectMapper msgPackObjectMapper) {
            this.msgPackObjectMapper = msgPackObjectMapper;
            return this;
        }

        public CallbackRequestResourceBuilder persistenceProvider(PersistenceProvider persistenceProvider) {
            this.persistenceProvider = persistenceProvider;
            return this;
        }

        public CallbackRequestResourceBuilder callbackHandler(InlineCallbackHandler callbackHandler) {
            this.callbackHandler = callbackHandler;
            return this;
        }

        public CallbackRequestResource build() {
            return new CallbackRequestResource(this.jsonObjectMapper, this.msgPackObjectMapper, this.persistenceProvider, this.callbackHandler);
        }

        public String toString() {
            return "CallbackRequestResource.CallbackRequestResourceBuilder(jsonObjectMapper=" + this.jsonObjectMapper + ", msgPackObjectMapper=" + this.msgPackObjectMapper + ", persistenceProvider=" + this.persistenceProvider + ", callbackHandler=" + this.callbackHandler + ")";
        }
    }
}

