/*
 * Decompiled with CFR 0.152.
 */
package com.platform.callback.resources;

import com.codahale.metrics.annotation.Metered;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.platform.callback.rabbitmq.ActionMessagePublisher;
import com.platform.callback.rabbitmq.actors.messages.CallbackMessage;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.base.core.RevolverCallbackRequest;
import io.dropwizard.revolver.base.core.RevolverCallbackResponse;
import io.dropwizard.revolver.http.RevolverHttpCommand;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import io.dropwizard.revolver.util.HeaderUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.Map;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/revolver")
@Singleton
@Api(value="RequestCallback", description="Revolver gateway api for callbacks on mailbox requests")
public class CallbackResource {
    private static final Logger log = LoggerFactory.getLogger(CallbackResource.class);
    private static final String RESPONSE_CODE_HEADER = "X-RESPONSE-CODE";
    private final PersistenceProvider persistenceProvider;

    public CallbackResource(PersistenceProvider persistenceProvider) {
        this.persistenceProvider = persistenceProvider;
    }

    @Path(value="/v1/callback/{requestId}")
    @POST
    @Metered
    @ApiOperation(value="Callback for updating responses for a given mailbox request")
    @Produces(value={"application/json", "application/msgpack", "application/xml"})
    @Consumes(value={"application/json", "application/msgpack", "application/xml"})
    public Response handleCallback(@PathParam(value="requestId") String requestId, @HeaderParam(value="X-RESPONSE-CODE") String responseCode, @Context HttpHeaders headers, @Context HttpServletRequest request) {
        long start = System.currentTimeMillis();
        try {
            RevolverCallbackRequest callbackRequest = this.persistenceProvider.request(requestId);
            if (callbackRequest == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            byte[] responseBody = ByteStreams.toByteArray((InputStream)request.getInputStream());
            RevolverCallbackResponse response = RevolverCallbackResponse.builder().body(responseBody).headers((Map)headers.getRequestHeaders()).statusCode(responseCode != null ? Integer.parseInt(responseCode) : Response.Status.OK.getStatusCode()).build();
            int mailboxTtl = HeaderUtil.getTTL((RevolverCallbackRequest)callbackRequest);
            this.persistenceProvider.saveResponse(requestId, response, mailboxTtl);
            if (callbackRequest.getMode() != null && (callbackRequest.getMode().equals("CALLBACK") || callbackRequest.getMode().equals("CALLBACK_SYNC")) && !Strings.isNullOrEmpty((String)callbackRequest.getCallbackUri())) {
                RevolverHttpCommand revolverHttpCommand = RevolverBundle.getHttpCommand((String)callbackRequest.getService(), (String)callbackRequest.getApi());
                String queueId = ((RevolverHttpApiConfig)revolverHttpCommand.getApiConfiguration()).getCallbackQueueId();
                ActionMessagePublisher.publish(CallbackMessage.builder().requestId(requestId).queueId(queueId).build());
            }
            log.info("Callback processing for request id: {} with response size: {} bytes completed in {} ms", new Object[]{requestId, responseBody.length, System.currentTimeMillis() - start});
            return Response.accepted().build();
        }
        catch (Exception e) {
            log.error("Callback error", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

