/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.dubbo;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.dubbo.config.DubboConfig;
import com.alibaba.csp.sentinel.context.ContextUtil;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ListenableFilter;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;

public abstract class BaseSentinelDubboFilter
extends ListenableFilter {
    public BaseSentinelDubboFilter() {
        this.listener = new SentinelDubboListener();
    }

    static void traceAndExit(Throwable throwable, URL url) {
        Entry interfaceEntry = (Entry)RpcContext.getContext().get("dubboInterfaceEntry");
        Entry methodEntry = (Entry)RpcContext.getContext().get("dubboMethodEntry");
        if (methodEntry != null) {
            Tracer.traceEntry((Throwable)throwable, (Entry)methodEntry);
            methodEntry.exit();
            RpcContext.getContext().remove("dubboMethodEntry");
        }
        if (interfaceEntry != null) {
            Tracer.traceEntry((Throwable)throwable, (Entry)interfaceEntry);
            interfaceEntry.exit();
            RpcContext.getContext().remove("dubboInterfaceEntry");
        }
        if ("provider".equals(url.getParameter("side"))) {
            ContextUtil.exit();
        }
    }

    static class SentinelDubboListener
    implements Filter.Listener {
        SentinelDubboListener() {
        }

        public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
            if (DubboConfig.getDubboBizExceptionTraceEnabled().booleanValue()) {
                BaseSentinelDubboFilter.traceAndExit(appResponse.getException(), invoker.getUrl());
            } else {
                BaseSentinelDubboFilter.traceAndExit(null, invoker.getUrl());
            }
        }

        public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
            BaseSentinelDubboFilter.traceAndExit(t, invoker.getUrl());
        }
    }
}

