/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.dubbo;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.adapter.dubbo.BaseSentinelDubboFilter;
import com.alibaba.csp.sentinel.adapter.dubbo.DubboUtils;
import com.alibaba.csp.sentinel.adapter.dubbo.config.DubboConfig;
import com.alibaba.csp.sentinel.adapter.dubbo.fallback.DubboFallbackRegistry;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider"})
public class SentinelDubboProviderFilter
extends BaseSentinelDubboFilter {
    public SentinelDubboProviderFilter() {
        RecordLog.info((String)"Sentinel Apache Dubbo provider filter initialized", (Object[])new Object[0]);
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String application = DubboUtils.getApplication(invocation, "");
        RpcContext rpcContext = RpcContext.getContext();
        Entry interfaceEntry = null;
        Entry methodEntry = null;
        try {
            String methodResourceName = DubboUtils.getResourceName(invoker, invocation, DubboConfig.getDubboProviderPrefix());
            String interfaceResourceName = DubboConfig.getDubboInterfaceGroupAndVersionEnabled() != false ? invoker.getUrl().getColonSeparatedKey() : invoker.getInterface().getName();
            ContextUtil.enter((String)methodResourceName, (String)application);
            interfaceEntry = SphU.entry((String)interfaceResourceName, (int)2, (EntryType)EntryType.IN);
            rpcContext.set("dubboInterfaceEntry", (Object)interfaceEntry);
            methodEntry = SphU.entry((String)methodResourceName, (int)2, (EntryType)EntryType.IN, (Object[])invocation.getArguments());
            rpcContext.set("dubboMethodEntry", (Object)methodEntry);
            return invoker.invoke(invocation);
        }
        catch (BlockException e) {
            return DubboFallbackRegistry.getProviderFallback().handle(invoker, invocation, e);
        }
    }
}

