/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.common.api.matcher;

import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiDefinition;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.function.Predicate;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractApiMatcher<T>
implements Predicate<T> {
    protected final String apiName;
    protected final ApiDefinition apiDefinition;
    protected final Set<Predicate<T>> matchers = new HashSet<Predicate<T>>();

    public AbstractApiMatcher(ApiDefinition apiDefinition) {
        AssertUtil.notNull((Object)apiDefinition, (String)"apiDefinition cannot be null");
        AssertUtil.assertNotBlank((String)apiDefinition.getApiName(), (String)"apiName cannot be empty");
        this.apiName = apiDefinition.getApiName();
        this.apiDefinition = apiDefinition;
        try {
            this.initializeMatchers();
        }
        catch (Exception ex) {
            RecordLog.warn((String)"[GatewayApiMatcher] Failed to initialize internal matchers", (Throwable)ex);
        }
    }

    protected abstract void initializeMatchers();

    public boolean test(T t) {
        for (Predicate<T> matcher : this.matchers) {
            if (!matcher.test(t)) continue;
            return true;
        }
        return false;
    }

    public String getApiName() {
        return this.apiName;
    }

    public ApiDefinition getApiDefinition() {
        return this.apiDefinition;
    }
}

