/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.rule;

import com.alibaba.csp.sentinel.cluster.flow.rule.NamespaceFlowProperty;
import com.alibaba.csp.sentinel.cluster.flow.statistic.ClusterParamMetricStatistics;
import com.alibaba.csp.sentinel.cluster.flow.statistic.metric.ClusterParamMetric;
import com.alibaba.csp.sentinel.cluster.server.connection.ConnectionManager;
import com.alibaba.csp.sentinel.cluster.server.util.ClusterRuleUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowClusterConfig;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleUtil;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.util.function.Function;
import com.alibaba.csp.sentinel.util.function.Predicate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ClusterParamFlowRuleManager {
    public static final Function<String, SentinelProperty<List<ParamFlowRule>>> DEFAULT_PROPERTY_SUPPLIER = new Function<String, SentinelProperty<List<ParamFlowRule>>>(){

        public SentinelProperty<List<ParamFlowRule>> apply(String namespace) {
            return new DynamicSentinelProperty();
        }
    };
    private static final Map<Long, ParamFlowRule> PARAM_RULES = new ConcurrentHashMap<Long, ParamFlowRule>();
    private static final Map<String, Set<Long>> NAMESPACE_FLOW_ID_MAP = new ConcurrentHashMap<String, Set<Long>>();
    private static final Map<Long, String> FLOW_NAMESPACE_MAP = new ConcurrentHashMap<Long, String>();
    private static final Map<String, NamespaceFlowProperty<ParamFlowRule>> PROPERTY_MAP = new ConcurrentHashMap<String, NamespaceFlowProperty<ParamFlowRule>>();
    private static volatile Function<String, SentinelProperty<List<ParamFlowRule>>> propertySupplier = DEFAULT_PROPERTY_SUPPLIER;
    private static final Object UPDATE_LOCK = new Object();

    private static void initDefaultProperty() {
        DynamicSentinelProperty defaultProperty = new DynamicSentinelProperty();
        String defaultNamespace = "default";
        ClusterParamFlowRuleManager.registerPropertyInternal(defaultNamespace, (SentinelProperty<List<ParamFlowRule>>)defaultProperty);
    }

    public static void setPropertySupplier(Function<String, SentinelProperty<List<ParamFlowRule>>> propertySupplier) {
        ClusterParamFlowRuleManager.propertySupplier = propertySupplier;
    }

    public static String getNamespace(long flowId) {
        return FLOW_NAMESPACE_MAP.get(flowId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(String namespace) {
        AssertUtil.notEmpty((String)namespace, (String)"namespace cannot be empty");
        if (propertySupplier == null) {
            RecordLog.warn((String)"[ClusterParamFlowRuleManager] Cluster param rule property supplier is absent, cannot register property", (Object[])new Object[0]);
            return;
        }
        SentinelProperty property = (SentinelProperty)propertySupplier.apply((Object)namespace);
        if (property == null) {
            RecordLog.warn((String)"[ClusterParamFlowRuleManager] Wrong created property from cluster param rule property supplier, ignoring", (Object[])new Object[0]);
            return;
        }
        Object object = UPDATE_LOCK;
        synchronized (object) {
            RecordLog.info((String)"[ClusterParamFlowRuleManager] Registering new property to cluster param rule manager for namespace <{0}>", (Object[])new Object[]{namespace});
            ClusterParamFlowRuleManager.registerPropertyInternal(namespace, (SentinelProperty<List<ParamFlowRule>>)property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPropertyIfAbsent(String namespace) {
        AssertUtil.notEmpty((String)namespace, (String)"namespace cannot be empty");
        if (!PROPERTY_MAP.containsKey(namespace)) {
            Object object = UPDATE_LOCK;
            synchronized (object) {
                if (!PROPERTY_MAP.containsKey(namespace)) {
                    ClusterParamFlowRuleManager.register2Property(namespace);
                }
            }
        }
    }

    private static void registerPropertyInternal(String namespace, SentinelProperty<List<ParamFlowRule>> property) {
        NamespaceFlowProperty<ParamFlowRule> oldProperty = PROPERTY_MAP.get(namespace);
        if (oldProperty != null) {
            oldProperty.getProperty().removeListener(oldProperty.getListener());
        }
        ParamRulePropertyListener listener = new ParamRulePropertyListener(namespace);
        property.addListener((PropertyListener)listener);
        PROPERTY_MAP.put(namespace, new NamespaceFlowProperty<ParamFlowRule>(namespace, property, listener));
        Set<Long> flowIdSet = NAMESPACE_FLOW_ID_MAP.get(namespace);
        if (flowIdSet == null) {
            ClusterParamFlowRuleManager.resetNamespaceFlowIdMapFor(namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProperty(String namespace) {
        AssertUtil.notEmpty((String)namespace, (String)"namespace cannot be empty");
        Object object = UPDATE_LOCK;
        synchronized (object) {
            NamespaceFlowProperty<ParamFlowRule> property = PROPERTY_MAP.get(namespace);
            if (property != null) {
                property.getProperty().removeListener(property.getListener());
                PROPERTY_MAP.remove(namespace);
            }
            RecordLog.info((String)"[ClusterParamFlowRuleManager] Removing property from cluster flow rule manager for namespace <{0}>", (Object[])new Object[]{namespace});
        }
    }

    private static void removePropertyListeners() {
        for (NamespaceFlowProperty<ParamFlowRule> property : PROPERTY_MAP.values()) {
            property.getProperty().removeListener(property.getListener());
        }
    }

    private static void restorePropertyListeners() {
        for (NamespaceFlowProperty<ParamFlowRule> p : PROPERTY_MAP.values()) {
            p.getProperty().removeListener(p.getListener());
            p.getProperty().addListener(p.getListener());
        }
    }

    private static void resetNamespaceFlowIdMapFor(String namespace) {
        NAMESPACE_FLOW_ID_MAP.put(namespace, new HashSet());
    }

    private static void clearAndResetRulesFor(String namespace) {
        Set<Long> flowIdSet = NAMESPACE_FLOW_ID_MAP.get(namespace);
        if (flowIdSet != null && !flowIdSet.isEmpty()) {
            for (Long flowId : flowIdSet) {
                PARAM_RULES.remove(flowId);
                FLOW_NAMESPACE_MAP.remove(flowId);
            }
            flowIdSet.clear();
        } else {
            ClusterParamFlowRuleManager.resetNamespaceFlowIdMapFor(namespace);
        }
    }

    private static void clearAndResetRulesConditional(String namespace, Predicate<Long> predicate) {
        Set<Long> oldIdSet = NAMESPACE_FLOW_ID_MAP.get(namespace);
        if (oldIdSet != null && !oldIdSet.isEmpty()) {
            for (Long flowId : oldIdSet) {
                if (!predicate.test((Object)flowId)) continue;
                PARAM_RULES.remove(flowId);
                FLOW_NAMESPACE_MAP.remove(flowId);
                ClusterParamMetricStatistics.removeMetric(flowId);
            }
            oldIdSet.clear();
        }
    }

    public static ParamFlowRule getParamRuleById(Long id) {
        if (!ClusterRuleUtil.validId(id)) {
            return null;
        }
        return PARAM_RULES.get(id);
    }

    public static Set<Long> getFlowIdSet(String namespace) {
        if (StringUtil.isEmpty((String)namespace)) {
            return new HashSet<Long>();
        }
        Set<Long> set = NAMESPACE_FLOW_ID_MAP.get(namespace);
        if (set == null) {
            return new HashSet<Long>();
        }
        return new HashSet<Long>(set);
    }

    public static List<ParamFlowRule> getAllParamRules() {
        return new ArrayList<ParamFlowRule>(PARAM_RULES.values());
    }

    public static List<ParamFlowRule> getParamRules(String namespace) {
        if (StringUtil.isEmpty((String)namespace)) {
            return new ArrayList<ParamFlowRule>();
        }
        ArrayList<ParamFlowRule> rules = new ArrayList<ParamFlowRule>();
        Set<Long> flowIdSet = NAMESPACE_FLOW_ID_MAP.get(namespace);
        if (flowIdSet == null || flowIdSet.isEmpty()) {
            return rules;
        }
        for (Long flowId : flowIdSet) {
            ParamFlowRule rule = PARAM_RULES.get(flowId);
            if (rule == null) continue;
            rules.add(rule);
        }
        return rules;
    }

    public static void loadRules(String namespace, List<ParamFlowRule> rules) {
        AssertUtil.notEmpty((String)namespace, (String)"namespace cannot be empty");
        NamespaceFlowProperty<ParamFlowRule> property = PROPERTY_MAP.get(namespace);
        if (property != null) {
            property.getProperty().updateValue(rules);
        }
    }

    public static int getConnectedCount(long flowId) {
        if (flowId <= 0L) {
            return 0;
        }
        String namespace = FLOW_NAMESPACE_MAP.get(flowId);
        if (namespace == null) {
            return 0;
        }
        return ConnectionManager.getConnectedCount(namespace);
    }

    private static void applyClusterParamRules(List<ParamFlowRule> list, String namespace) {
        if (list == null || list.isEmpty()) {
            ClusterParamFlowRuleManager.clearAndResetRulesFor(namespace);
            return;
        }
        final ConcurrentHashMap<Long, ParamFlowRule> ruleMap = new ConcurrentHashMap<Long, ParamFlowRule>();
        HashSet<Long> flowIdSet = new HashSet<Long>();
        for (ParamFlowRule rule : list) {
            if (!rule.isClusterMode()) continue;
            if (!ParamFlowRuleUtil.isValidRule((ParamFlowRule)rule)) {
                RecordLog.warn((String)("[ClusterParamFlowRuleManager] Ignoring invalid param flow rule when loading new flow rules: " + rule), (Object[])new Object[0]);
                continue;
            }
            if (StringUtil.isBlank((String)rule.getLimitApp())) {
                rule.setLimitApp("default");
            }
            ParamFlowRuleUtil.fillExceptionFlowItems((ParamFlowRule)rule);
            ParamFlowClusterConfig clusterConfig = rule.getClusterConfig();
            Long flowId = clusterConfig.getFlowId();
            if (flowId == null) continue;
            ruleMap.put(flowId, rule);
            FLOW_NAMESPACE_MAP.put(flowId, namespace);
            flowIdSet.add(flowId);
            ClusterParamMetricStatistics.putMetricIfAbsent(flowId, new ClusterParamMetric(clusterConfig.getSampleCount(), clusterConfig.getWindowIntervalMs()));
        }
        ClusterParamFlowRuleManager.clearAndResetRulesConditional(namespace, new Predicate<Long>(){

            public boolean test(Long flowId) {
                return !ruleMap.containsKey(flowId);
            }
        });
        PARAM_RULES.putAll(ruleMap);
        NAMESPACE_FLOW_ID_MAP.put(namespace, flowIdSet);
    }

    private ClusterParamFlowRuleManager() {
    }

    static {
        ClusterParamFlowRuleManager.initDefaultProperty();
    }

    private static class ParamRulePropertyListener
    implements PropertyListener<List<ParamFlowRule>> {
        private final String namespace;

        public ParamRulePropertyListener(String namespace) {
            this.namespace = namespace;
        }

        public void configLoad(List<ParamFlowRule> conf) {
            ClusterParamFlowRuleManager.applyClusterParamRules(conf, this.namespace);
            RecordLog.info((String)"[ClusterParamFlowRuleManager] Cluster parameter rules loaded for namespace <{0}>: {1}", (Object[])new Object[]{this.namespace, PARAM_RULES});
        }

        public void configUpdate(List<ParamFlowRule> conf) {
            ClusterParamFlowRuleManager.applyClusterParamRules(conf, this.namespace);
            RecordLog.info((String)"[ClusterParamFlowRuleManager] Cluster parameter rules received for namespace <{0}>: {1}", (Object[])new Object[]{this.namespace, PARAM_RULES});
        }
    }
}

