/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.envoy.rls;

import com.alibaba.csp.sentinel.cluster.server.envoy.rls.SentinelRlsGrpcServer;
import com.alibaba.csp.sentinel.cluster.server.envoy.rls.datasource.EnvoyRlsRuleDataSourceService;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.init.InitExecutor;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Optional;

public class SentinelEnvoyRlsServer {
    public static void main(String[] args) throws Exception {
        System.setProperty("project.name", "sentinel-rls-token-server");
        EnvoyRlsRuleDataSourceService dataSourceService = new EnvoyRlsRuleDataSourceService();
        dataSourceService.init();
        int port = SentinelEnvoyRlsServer.resolvePort();
        SentinelRlsGrpcServer server = new SentinelRlsGrpcServer(port);
        server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.err.println("[SentinelEnvoyRlsServer] Shutting down gRPC RLS server since JVM is shutting down");
            server.shutdown();
            dataSourceService.onShutdown();
            System.err.println("[SentinelEnvoyRlsServer] Server has been shut down");
        }));
        InitExecutor.doInit();
        server.blockUntilShutdown();
    }

    private static int resolvePort() {
        int defaultPort = 10245;
        String portStr = Optional.ofNullable(System.getenv("SENTINEL_RLS_GRPC_PORT")).orElse(SentinelConfig.getConfig((String)"csp.sentinel.grpc.server.port"));
        if (StringUtil.isBlank((String)portStr)) {
            return 10245;
        }
        try {
            int port = Integer.parseInt(portStr);
            if (port <= 0 || port > 65535) {
                RecordLog.warn((String)("[SentinelEnvoyRlsServer] Invalid port <" + portStr + ">, using default" + 10245), (Object[])new Object[0]);
                return 10245;
            }
            return port;
        }
        catch (Exception ex) {
            RecordLog.warn((String)"[SentinelEnvoyRlsServer] Failed to resolve port, using default 10245", (Object[])new Object[0]);
            System.err.println("[SentinelEnvoyRlsServer] Failed to resolve port, using default 10245");
            return 10245;
        }
    }
}

