/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.envoy.rls;

import com.alibaba.csp.sentinel.cluster.TokenResult;
import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterFlowRuleManager;
import com.alibaba.csp.sentinel.cluster.server.envoy.rls.flow.SimpleClusterFlowChecker;
import com.alibaba.csp.sentinel.cluster.server.envoy.rls.log.RlsAccessLogger;
import com.alibaba.csp.sentinel.cluster.server.envoy.rls.rule.EnvoySentinelRuleConverter;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.util.function.Tuple2;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import io.envoyproxy.envoy.api.v2.ratelimit.RateLimitDescriptor;
import io.envoyproxy.envoy.service.ratelimit.v2.RateLimitRequest;
import io.envoyproxy.envoy.service.ratelimit.v2.RateLimitResponse;
import io.envoyproxy.envoy.service.ratelimit.v2.RateLimitServiceGrpc;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;

public class SentinelEnvoyRlsServiceImpl
extends RateLimitServiceGrpc.RateLimitServiceImplBase {
    @Override
    public void shouldRateLimit(RateLimitRequest request, StreamObserver<RateLimitResponse> responseObserver) {
        int acquireCount = request.getHitsAddend();
        if (acquireCount < 0) {
            responseObserver.onError((Throwable)new IllegalArgumentException("acquireCount should be positive, but actual: " + acquireCount));
            return;
        }
        if (acquireCount == 0) {
            acquireCount = 1;
        }
        String domain = request.getDomain();
        boolean blocked = false;
        ArrayList<RateLimitResponse.DescriptorStatus> statusList = new ArrayList<RateLimitResponse.DescriptorStatus>(request.getDescriptorsCount());
        for (RateLimitDescriptor descriptor : request.getDescriptorsList()) {
            Tuple2<FlowRule, TokenResult> t = this.checkToken(domain, descriptor, acquireCount);
            TokenResult r = (TokenResult)t.r2;
            this.printAccessLogIfNecessary(domain, descriptor, r);
            if (r.getStatus() == 3) {
                r.setStatus(Integer.valueOf(0));
            }
            if (!blocked && r.getStatus() != 0) {
                blocked = true;
            }
            RateLimitResponse.Code statusCode = r.getStatus() == 0 ? RateLimitResponse.Code.OK : RateLimitResponse.Code.OVER_LIMIT;
            RateLimitResponse.DescriptorStatus.Builder descriptorStatusBuilder = RateLimitResponse.DescriptorStatus.newBuilder().setCode(statusCode);
            if (t.r1 != null) {
                descriptorStatusBuilder.setCurrentLimit(RateLimitResponse.RateLimit.newBuilder().setUnit(RateLimitResponse.RateLimit.Unit.SECOND).setRequestsPerUnit((int)((FlowRule)t.r1).getCount()).build()).setLimitRemaining(r.getRemaining());
            }
            statusList.add(descriptorStatusBuilder.build());
        }
        RateLimitResponse.Code overallStatus = blocked ? RateLimitResponse.Code.OVER_LIMIT : RateLimitResponse.Code.OK;
        RateLimitResponse response = RateLimitResponse.newBuilder().setOverallCode(overallStatus).addAllStatuses(statusList).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    private void printAccessLogIfNecessary(String domain, RateLimitDescriptor descriptor, TokenResult result) {
        if (!RlsAccessLogger.isEnabled()) {
            return;
        }
        String message = "[RlsAccessLog] domain=" + domain + ", descriptor=" + TextFormat.shortDebugString((MessageOrBuilder)descriptor) + ", checkStatus=" + result.getStatus() + ", remaining=" + result.getRemaining();
        RlsAccessLogger.log(message);
    }

    protected Tuple2<FlowRule, TokenResult> checkToken(String domain, RateLimitDescriptor descriptor, int acquireCount) {
        long ruleId = EnvoySentinelRuleConverter.generateFlowId(this.generateKey(domain, descriptor));
        FlowRule rule = ClusterFlowRuleManager.getFlowRuleById((Long)ruleId);
        if (rule == null) {
            return Tuple2.of(null, (Object)new TokenResult(Integer.valueOf(3)));
        }
        return Tuple2.of((Object)rule, (Object)SimpleClusterFlowChecker.acquireClusterToken(rule, acquireCount));
    }

    private String generateKey(String domain, RateLimitDescriptor descriptor) {
        StringBuilder sb = new StringBuilder(domain);
        for (RateLimitDescriptor.Entry resource : descriptor.getEntriesList()) {
            sb.append("|").append(resource.getKey()).append("|").append(resource.getValue());
        }
        return sb.toString();
    }
}

