/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource.etcd;

import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.util.StringUtil;

public final class EtcdConfig {
    public static final String END_POINTS = "csp.sentinel.etcd.endpoints";
    public static final String USER = "csp.sentinel.etcd.user";
    public static final String PASSWORD = "csp.sentinel.etcd.password";
    public static final String CHARSET = "csp.sentinel.etcd.charset";
    public static final String AUTH_ENABLE = "csp.sentinel.etcd.auth.enable";
    public static final String AUTHORITY = "csp.sentinel.etcd.authority";
    private static final String ENABLED = "true";

    public static String getEndPoints() {
        return SentinelConfig.getConfig((String)END_POINTS);
    }

    public static String getUser() {
        return SentinelConfig.getConfig((String)USER);
    }

    public static String getPassword() {
        return SentinelConfig.getConfig((String)PASSWORD);
    }

    public static String getCharset() {
        String etcdCharset = SentinelConfig.getConfig((String)CHARSET);
        if (StringUtil.isNotBlank((String)etcdCharset)) {
            return etcdCharset;
        }
        return SentinelConfig.charset();
    }

    public static boolean isAuthEnable() {
        return ENABLED.equalsIgnoreCase(SentinelConfig.getConfig((String)AUTH_ENABLE));
    }

    public static String getAuthority() {
        return SentinelConfig.getConfig((String)AUTHORITY);
    }

    private EtcdConfig() {
    }
}

