/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource.spring.cloud.config;

import com.alibaba.csp.sentinel.datasource.spring.cloud.config.SentinelRuleStorage;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigClientStateHolder;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.retry.annotation.Retryable;
import org.springframework.util.Base64Utils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Order(value=0)
public class SentinelRuleLocator
implements PropertySourceLocator {
    private RestTemplate restTemplate;
    private ConfigClientProperties defaultProperties;
    private org.springframework.core.env.Environment environment;

    public SentinelRuleLocator(ConfigClientProperties defaultProperties, org.springframework.core.env.Environment environment) {
        this.defaultProperties = defaultProperties;
        this.environment = environment;
    }

    @Retryable(interceptor="configServerRetryInterceptor")
    public PropertySource<?> locate(org.springframework.core.env.Environment environment) {
        ConfigClientProperties properties = this.defaultProperties.override(environment);
        CompositePropertySource composite = new CompositePropertySource("configService");
        RestTemplate restTemplate = this.restTemplate == null ? this.getSecureRestTemplate(properties) : this.restTemplate;
        Throwable error = null;
        String errorBody = null;
        try {
            String[] labels = new String[]{""};
            if (StringUtils.hasText((String)properties.getLabel())) {
                labels = StringUtils.commaDelimitedListToStringArray((String)properties.getLabel());
            }
            String state = ConfigClientStateHolder.getState();
            for (String label : labels) {
                Environment result = this.getRemoteEnvironment(restTemplate, properties, label.trim(), state);
                if (result == null) continue;
                this.log(result);
                if (result.getPropertySources() != null) {
                    for (org.springframework.cloud.config.environment.PropertySource source : result.getPropertySources()) {
                        Map map = source.getSource();
                        composite.addPropertySource((PropertySource)new MapPropertySource(source.getName(), map));
                    }
                }
                SentinelRuleStorage.setRulesSource(composite);
                return composite;
            }
        }
        catch (HttpServerErrorException e) {
            error = e;
            if (MediaType.APPLICATION_JSON.includes(e.getResponseHeaders().getContentType())) {
                errorBody = e.getResponseBodyAsString();
            }
        }
        catch (Exception e) {
            error = e;
        }
        if (properties.isFailFast()) {
            throw new IllegalStateException("Could not locate PropertySource and the fail fast property is set, failing", error);
        }
        RecordLog.warn((String)("Could not locate PropertySource: " + (errorBody == null ? (error == null ? "label not found" : error.getMessage()) : errorBody)), (Object[])new Object[0]);
        return null;
    }

    public PropertySource<?> refresh() {
        return this.locate(this.environment);
    }

    private void log(Environment result) {
        RecordLog.info((String)String.format("Located environment: name=%s, profiles=%s, label=%s, version=%s, state=%s", result.getName(), result.getProfiles() == null ? "" : Arrays.asList(result.getProfiles()), result.getLabel(), result.getVersion(), result.getState()), (Object[])new Object[0]);
        List propertySourceList = result.getPropertySources();
        if (propertySourceList != null) {
            int propertyCount = 0;
            for (org.springframework.cloud.config.environment.PropertySource propertySource : propertySourceList) {
                propertyCount += propertySource.getSource().size();
            }
            RecordLog.info((String)String.format("Environment %s has %d property sources with %d properties.", result.getName(), result.getPropertySources().size(), propertyCount), (Object[])new Object[0]);
        }
    }

    private Environment getRemoteEnvironment(RestTemplate restTemplate, ConfigClientProperties properties, String label, String state) {
        String path = "/{name}/{profile}";
        String name = properties.getName();
        String profile = properties.getProfile();
        String token = properties.getToken();
        int noOfUrls = properties.getUri().length;
        if (noOfUrls > 1) {
            RecordLog.info((String)"Multiple Config Server Urls found listed.", (Object[])new Object[0]);
        }
        RecordLog.info((String)"properties = {0},label={1}, state={2}", (Object[])new Object[]{properties, label, state});
        Object[] args = new String[]{name, profile};
        if (StringUtils.hasText((String)label)) {
            if (label.contains("/")) {
                label = label.replace("/", "(_)");
            }
            args = new String[]{name, profile, label};
            path = path + "/{label}";
        }
        ResponseEntity response = null;
        for (int i = 0; i < noOfUrls; ++i) {
            ConfigClientProperties.Credentials credentials = properties.getCredentials(i);
            String uri = credentials.getUri();
            String username = credentials.getUsername();
            String password = credentials.getPassword();
            RecordLog.info((String)("Fetching config from server at : " + uri), (Object[])new Object[0]);
            try {
                HttpHeaders headers = new HttpHeaders();
                this.addAuthorizationToken(properties, headers, username, password);
                if (StringUtils.hasText((String)token)) {
                    headers.add("X-Config-Token", token);
                }
                if (StringUtils.hasText((String)state) && properties.isSendState()) {
                    headers.add("X-Config-State", state);
                }
                HttpEntity entity = new HttpEntity((Object)null, (MultiValueMap)headers);
                response = restTemplate.exchange(uri + path, HttpMethod.GET, entity, Environment.class, args);
            }
            catch (HttpClientErrorException e) {
                if (e.getStatusCode() != HttpStatus.NOT_FOUND) {
                    throw e;
                }
            }
            catch (ResourceAccessException e) {
                RecordLog.info((String)("Connect Timeout Exception on Url - " + uri + ". Will be trying the next url if available"), (Object[])new Object[0]);
                if (i != noOfUrls - 1) continue;
                throw e;
            }
            if (response == null || response.getStatusCode() != HttpStatus.OK) {
                return null;
            }
            Environment result = (Environment)response.getBody();
            return result;
        }
        return null;
    }

    private RestTemplate getSecureRestTemplate(ConfigClientProperties client) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        if (client.getRequestReadTimeout() < 0) {
            throw new IllegalStateException("Invalid Value for Read Timeout set.");
        }
        requestFactory.setReadTimeout(client.getRequestReadTimeout());
        RestTemplate template = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        HashMap<String, String> headers = new HashMap<String, String>(client.getHeaders());
        if (headers.containsKey("authorization")) {
            headers.remove("authorization");
        }
        if (!headers.isEmpty()) {
            template.setInterceptors(Arrays.asList(new GenericRequestHeaderInterceptor(headers)));
        }
        return template;
    }

    private void addAuthorizationToken(ConfigClientProperties configClientProperties, HttpHeaders httpHeaders, String username, String password) {
        String authorization = (String)configClientProperties.getHeaders().get("authorization");
        if (password != null && authorization != null) {
            throw new IllegalStateException("You must set either 'password' or 'authorization'");
        }
        if (password != null) {
            byte[] token = Base64Utils.encode((byte[])(username + ":" + password).getBytes());
            httpHeaders.add("Authorization", "Basic " + new String(token));
        } else if (authorization != null) {
            httpHeaders.add("Authorization", authorization);
        }
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public static class GenericRequestHeaderInterceptor
    implements ClientHttpRequestInterceptor {
        private final Map<String, String> headers;

        public GenericRequestHeaderInterceptor(Map<String, String> headers) {
            this.headers = headers;
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                request.getHeaders().add(header.getKey(), header.getValue());
            }
            return execution.execute(request, body);
        }

        protected Map<String, String> getHeaders() {
            return this.headers;
        }
    }
}

