/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource.spring.cloud.config;

import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.spring.cloud.config.SentinelRuleStorage;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SpringCloudConfigDataSource<T>
extends AbstractDataSource<String, T> {
    private static final Map<SpringCloudConfigDataSource, SpringConfigListener> listeners = new ConcurrentHashMap<SpringCloudConfigDataSource, SpringConfigListener>();
    private final String ruleKey;

    public SpringCloudConfigDataSource(String ruleKey, Converter<String, T> converter) {
        super(converter);
        if (StringUtil.isBlank((String)ruleKey)) {
            throw new IllegalArgumentException(String.format("Bad argument: ruleKey=[%s]", ruleKey));
        }
        this.ruleKey = ruleKey;
        this.loadInitialConfig();
        this.initListener();
    }

    private void loadInitialConfig() {
        try {
            Object newValue = this.loadConfig();
            if (newValue == null) {
                RecordLog.warn((String)"[SpringCloudConfigDataSource] WARN: initial application is null, you may have to check your data source", (Object[])new Object[0]);
            }
            this.getProperty().updateValue(newValue);
        }
        catch (Exception ex) {
            RecordLog.warn((String)"[SpringCloudConfigDataSource] Error when loading initial application", (Throwable)ex);
        }
    }

    private void initListener() {
        listeners.put(this, new SpringConfigListener(this));
    }

    public String readSource() {
        return SentinelRuleStorage.retrieveRule(this.ruleKey);
    }

    public void close() throws Exception {
        listeners.remove((Object)this);
    }

    public static void updateValues() {
        for (SpringConfigListener listener : listeners.values()) {
            listener.listenChanged();
        }
    }

    private static class SpringConfigListener {
        private SpringCloudConfigDataSource dataSource;

        public SpringConfigListener(SpringCloudConfigDataSource dataSource) {
            this.dataSource = dataSource;
        }

        public void listenChanged() {
            try {
                Object newValue = this.dataSource.loadConfig();
                this.dataSource.getProperty().updateValue(newValue);
            }
            catch (Exception e) {
                RecordLog.warn((String)"[SpringConfigListener] load config error: ", (Throwable)e);
            }
        }
    }
}

