/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.sc;

import com.alibaba.csp.sentinel.adapter.gateway.common.param.RequestItemParser;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.springframework.http.HttpCookie;
import org.springframework.http.ResponseCookie;
import org.springframework.web.server.ServerWebExchange;

public class ServerWebExchangeItemParser
implements RequestItemParser<ServerWebExchange> {
    public String getPath(ServerWebExchange exchange) {
        return exchange.getRequest().getPath().value();
    }

    public String getRemoteAddress(ServerWebExchange exchange) {
        InetSocketAddress remoteAddress = exchange.getRequest().getRemoteAddress();
        if (remoteAddress == null) {
            return null;
        }
        return remoteAddress.getAddress().getHostAddress();
    }

    public String getHeader(ServerWebExchange exchange, String key) {
        return exchange.getRequest().getHeaders().getFirst(key);
    }

    public String getUrlParam(ServerWebExchange exchange, String paramName) {
        return (String)exchange.getRequest().getQueryParams().getFirst((Object)paramName);
    }

    public String getCookieValue(ServerWebExchange exchange, String cookieName) {
        return Optional.ofNullable((ResponseCookie)exchange.getResponse().getCookies().getFirst((Object)cookieName)).map(HttpCookie::getValue).orElse(null);
    }
}

