/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.command;

import com.alibaba.csp.sentinel.command.CommandHandlerProvider;
import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.spi.SpiOrder;
import com.alibaba.csp.sentinel.transport.CommandCenter;
import com.alibaba.csp.sentinel.transport.command.netty.HttpServer;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

@SpiOrder(value=2147483547)
public class NettyHttpCommandCenter
implements CommandCenter {
    private final HttpServer server = new HttpServer();
    private final ExecutorService pool = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("sentinel-netty-command-center-executor"));

    public void start() throws Exception {
        this.pool.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    NettyHttpCommandCenter.this.server.start();
                }
                catch (Exception ex) {
                    RecordLog.info((String)"Start netty server error", (Throwable)ex);
                    ex.printStackTrace();
                    System.exit(-1);
                }
            }
        });
    }

    public void stop() throws Exception {
        this.server.close();
        this.pool.shutdownNow();
    }

    public void beforeStart() throws Exception {
        Map handlers = CommandHandlerProvider.getInstance().namedHandlers();
        this.server.registerCommands(handlers);
    }
}

