/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.command.netty;

import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.log.CommandCenterLog;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.transport.command.netty.HttpServerInitializer;
import com.alibaba.csp.sentinel.transport.config.TransportConfig;
import com.alibaba.csp.sentinel.util.StringUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public final class HttpServer {
    private static final int DEFAULT_PORT = 8719;
    private Channel channel;
    static final Map<String, CommandHandler> handlerMap = new ConcurrentHashMap<String, CommandHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            int port;
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new HttpServerInitializer());
            try {
                if (StringUtil.isEmpty((String)TransportConfig.getPort())) {
                    CommandCenterLog.info((String)"Port not configured, using default port: 8719", (Object[])new Object[0]);
                    port = 8719;
                } else {
                    port = Integer.parseInt(TransportConfig.getPort());
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal port: " + TransportConfig.getPort());
            }
            int retryCount = 0;
            ChannelFuture channelFuture = null;
            while (true) {
                int newPort = this.getNewPort(port, retryCount);
                try {
                    channelFuture = b.bind(newPort).sync();
                    TransportConfig.setRuntimePort((int)newPort);
                    CommandCenterLog.info((String)("[NettyHttpCommandCenter] Begin listening at port " + newPort), (Object[])new Object[0]);
                }
                catch (Exception e) {
                    TimeUnit.MILLISECONDS.sleep(30L);
                    RecordLog.warn((String)"[HttpServer] Netty server bind error, port={0}, retry={1}", (Object[])new Object[]{newPort, retryCount});
                    ++retryCount;
                    continue;
                }
                break;
            }
            this.channel = channelFuture.channel();
            this.channel.closeFuture().sync();
        }
        finally {
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
        }
    }

    private int getNewPort(int basePort, int retryCount) {
        return basePort + retryCount / 3;
    }

    public void close() {
        this.channel.close();
    }

    public void registerCommand(String commandName, CommandHandler handler) {
        if (StringUtil.isEmpty((String)commandName) || handler == null) {
            return;
        }
        if (handlerMap.containsKey(commandName)) {
            CommandCenterLog.warn((String)("[NettyHttpCommandCenter] Register failed (duplicate command): " + commandName), (Object[])new Object[0]);
            return;
        }
        handlerMap.put(commandName, handler);
    }

    public void registerCommands(Map<String, CommandHandler> handlerMap) {
        if (handlerMap != null) {
            for (Map.Entry<String, CommandHandler> e : handlerMap.entrySet()) {
                this.registerCommand(e.getKey(), e.getValue());
            }
        }
    }
}

