/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.zuul.fallback;

import com.alibaba.csp.sentinel.adapter.gateway.zuul.fallback.DefaultBlockFallbackProvider;
import com.alibaba.csp.sentinel.adapter.gateway.zuul.fallback.ZuulBlockFallbackProvider;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.HashMap;
import java.util.Map;

public class ZuulBlockFallbackManager {
    private static Map<String, ZuulBlockFallbackProvider> fallbackProviderCache = new HashMap<String, ZuulBlockFallbackProvider>();
    private static ZuulBlockFallbackProvider defaultFallbackProvider = new DefaultBlockFallbackProvider();

    public static synchronized void registerProvider(ZuulBlockFallbackProvider provider) {
        AssertUtil.notNull((Object)provider, (String)"fallback provider cannot be null");
        String route = provider.getRoute();
        if ("*".equals(route) || route == null) {
            defaultFallbackProvider = provider;
        } else {
            fallbackProviderCache.put(route, provider);
        }
    }

    public static ZuulBlockFallbackProvider getFallbackProvider(String route) {
        ZuulBlockFallbackProvider provider = fallbackProviderCache.get(route);
        if (provider == null) {
            provider = defaultFallbackProvider;
        }
        return provider;
    }

    public static synchronized void clear() {
        fallbackProviderCache.clear();
    }
}

