/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.zuul.filters;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.gateway.zuul.filters.EntryHolder;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.netflix.zuul.context.RequestContext;
import java.util.Deque;

final class SentinelEntryUtils {
    static void tryExitFromCurrentContext() {
        RequestContext ctx = RequestContext.getCurrentContext();
        if (ctx.containsKey((Object)"_sentinel_entries")) {
            Deque holders = (Deque)ctx.get((Object)"_sentinel_entries");
            while (!holders.isEmpty()) {
                EntryHolder holder = (EntryHolder)holders.pop();
                SentinelEntryUtils.exit(holder);
            }
            ctx.remove((Object)"_sentinel_entries");
        }
        ContextUtil.exit();
    }

    static void tryTraceExceptionThenExitFromCurrentContext(Throwable t) {
        RequestContext ctx = RequestContext.getCurrentContext();
        if (ctx.containsKey((Object)"_sentinel_entries")) {
            Deque holders = (Deque)ctx.get((Object)"_sentinel_entries");
            while (!holders.isEmpty()) {
                EntryHolder holder = (EntryHolder)holders.pop();
                Tracer.traceEntry((Throwable)t, (Entry)holder.getEntry());
                SentinelEntryUtils.exit(holder);
            }
            ctx.remove((Object)"_sentinel_entries");
        }
        ContextUtil.exit();
    }

    static void exit(EntryHolder holder) {
        Entry entry = holder.getEntry();
        entry.exit(1, holder.getParams());
    }

    private SentinelEntryUtils() {
    }
}

