/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.features.jackson.integration;

import com.englishtown.vertx.jersey.integration.JerseyHK2IntegrationTestBase;
import com.englishtown.vertx.promises.RequestOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import org.junit.Test;

public class JacksonIntegrationTest
extends JerseyHK2IntegrationTestBase {
    public static final String BASE_PATH = "http://localhost:8080/test";

    @Test
    public void testJsonObject_Empty() throws Exception {
        this.runTest(BASE_PATH, Response.Status.NO_CONTENT.getStatusCode(), this.getRequestOptions(), body -> this.assertEquals(0L, body.length()));
    }

    @Test
    public void testJsonObject() throws Exception {
        JsonObject json = new JsonObject().put("b", "c").put("a", Integer.valueOf(1));
        RequestOptions options = this.getRequestOptions().setData(json.encode());
        this.runTest(BASE_PATH, Response.Status.OK.getStatusCode(), options, body -> {
            JsonObject result = new JsonObject(body.toString());
            this.assertEquals(json, result);
        });
    }

    @Test
    public void testJsonObject_Bad_Request() throws Exception {
        RequestOptions options = this.getRequestOptions().setData("{ ...");
        this.runTest(BASE_PATH, Response.Status.BAD_REQUEST.getStatusCode(), options, null);
    }

    @Test
    public void testJsonArray() throws Exception {
        JsonArray json = new JsonArray().add(Integer.valueOf(1)).add("a");
        RequestOptions options = this.getRequestOptions().setData(json.encode());
        this.runTest("http://localhost:8080/test/array", Response.Status.OK.getStatusCode(), options, body -> {
            JsonArray result = new JsonArray(body.toString());
            this.assertEquals(json, result);
        });
    }

    @Test
    public void testJsonArray_Bad_Request() throws Exception {
        RequestOptions options = this.getRequestOptions().setData("[1, ...");
        this.runTest("http://localhost:8080/test/array", Response.Status.BAD_REQUEST.getStatusCode(), options, null);
    }

    @Test
    public void testObject() throws Exception {
        JsonObject json = new JsonObject().put("prop1", "c").put("prop2", Integer.valueOf(1)).put("prop_with_camel_casing_to_replace", "a");
        RequestOptions options = this.getRequestOptions().setData(json.encode());
        this.runTest("http://localhost:8080/test/obj", Response.Status.OK.getStatusCode(), options, body -> {
            JsonObject result = new JsonObject(body.toString());
            this.assertEquals(json, result);
        });
    }

    private void runTest(String path, int expectedStatus, RequestOptions options, Consumer<Buffer> bodyValidator) throws Exception {
        this.getWhenHttpClient().requestAbs(HttpMethod.POST, path, options).then(response -> {
            this.assertEquals(expectedStatus, response.statusCode());
            return this.getWhenHttpClient().body(response);
        }).then(body -> {
            if (bodyValidator != null) {
                bodyValidator.accept((Buffer)body);
            }
            this.testComplete();
            return null;
        });
        this.await();
    }

    private RequestOptions getRequestOptions() {
        return new RequestOptions().setPauseResponse(true).addHeader("Content-Type", "application/json");
    }
}

