/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.features.jackson.internal;

import com.englishtown.vertx.jersey.features.jackson.ObjectMapperConfigurator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import javax.inject.Inject;

public class JsonConfigObjectMapperConfigurator
implements ObjectMapperConfigurator {
    private JsonObject config;
    public static final String CONFIG_PROPERTY_NAMING_STRATEGY = "property_naming_strategy";

    @Inject
    public JsonConfigObjectMapperConfigurator(Vertx vertx) {
        this.config = vertx.getOrCreateContext().config();
        this.config = this.config.getJsonObject("jersey", this.config).getJsonObject("jackson", this.config);
    }

    @Override
    public void configure(ObjectMapper mapper) {
        this.setPropertyNamingStrategy(mapper);
    }

    protected void setPropertyNamingStrategy(ObjectMapper mapper) {
        String s = this.config.getString(CONFIG_PROPERTY_NAMING_STRATEGY);
        if (s == null) {
            return;
        }
        if (PropertyNamingStrategy.SnakeCaseStrategy.class.getSimpleName().equalsIgnoreCase(s) || PropertyNamingStrategy.LowerCaseWithUnderscoresStrategy.class.getSimpleName().equalsIgnoreCase(s)) {
            mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
            return;
        }
        if (PropertyNamingStrategy.LowerCaseStrategy.class.getSimpleName().equalsIgnoreCase(s)) {
            mapper.setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CASE);
            return;
        }
        if (PropertyNamingStrategy.UpperCamelCaseStrategy.class.getSimpleName().equalsIgnoreCase(s) || PropertyNamingStrategy.PascalCaseStrategy.class.getSimpleName().equalsIgnoreCase(s)) {
            mapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
            return;
        }
        if (PropertyNamingStrategy.KebabCaseStrategy.class.getSimpleName().equalsIgnoreCase(s)) {
            mapper.setPropertyNamingStrategy(PropertyNamingStrategy.KEBAB_CASE);
            return;
        }
        throw new IllegalArgumentException("Property naming strategy " + s + " is not supported");
    }
}

