/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.englishtown.vertx.jersey.inject.VertxRequestProcessor;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import javax.inject.Inject;
import org.glassfish.jersey.server.ContainerRequest;

public class RequestProcessor
implements VertxRequestProcessor {
    public static final String FIRST_BYTE_TIMER_CONTEXT = "et.timer.firstByte.context";
    public static final String LAST_BYTE_TIMER_CONTEXT = "et.timer.lastByte.context";
    public static final String FIRST_BYTE_TIMER_NAME = "et.metrics.jersey.firstByte";
    public static final String LAST_BYTE_TIMER_NAME = "et.metrics.jersey.lastByte";
    private final Timer firstByteTimer;
    private final Timer lastByteTimer;

    @Inject
    public RequestProcessor(MetricRegistry registry) {
        this.firstByteTimer = registry.timer(FIRST_BYTE_TIMER_NAME);
        this.lastByteTimer = registry.timer(LAST_BYTE_TIMER_NAME);
    }

    public void process(HttpServerRequest vertxRequest, ContainerRequest jerseyRequest, Handler<Void> done) {
        jerseyRequest.setProperty(FIRST_BYTE_TIMER_CONTEXT, (Object)this.firstByteTimer.time());
        jerseyRequest.setProperty(LAST_BYTE_TIMER_CONTEXT, (Object)this.lastByteTimer.time());
        done.handle(null);
    }
}

