/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.features.swagger.internal;

import io.swagger.config.SwaggerConfig;
import io.swagger.jaxrs.config.SwaggerContextService;
import io.swagger.models.Swagger;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Configuration;

class SwaggerServletConfig
implements ServletConfig {
    private ServletContext context;
    private Map<String, String> initParams = new HashMap<String, String>();
    public static final String PROPERTY_PREFIX = "swagger.";

    @Inject
    public SwaggerServletConfig(ServletContext context, Configuration config) {
        this.context = context;
        config.getProperties().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(PROPERTY_PREFIX)).filter(entry -> entry.getValue() != null).forEach(entry -> this.initParams.put((String)entry.getKey(), entry.getValue().toString()));
        Function<String, String> getValue = name -> {
            Object val = config.getProperty(name);
            return val == null ? null : val.toString();
        };
        new SwaggerContextService().withConfigId(getValue.apply("swagger.config.id")).withScannerId(getValue.apply("swagger.scanner.id")).withContextId(getValue.apply("swagger.context.id")).withBasePath(context.getContextPath()).withSwaggerConfig((SwaggerConfig)new DefaultSwaggerConfig(context)).withServletConfig((ServletConfig)this).initConfig().initScanner();
    }

    public String getServletName() {
        return this.getClass().getSimpleName();
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public String getInitParameter(String name) {
        return this.initParams.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParams.keySet());
    }

    private static class DefaultSwaggerConfig
    implements SwaggerConfig {
        private ServletContext context;

        public DefaultSwaggerConfig(ServletContext context) {
            this.context = context;
        }

        public Swagger configure(Swagger swagger) {
            String basePath = this.context.getContextPath();
            if (basePath.endsWith("/")) {
                basePath = basePath.substring(0, basePath.length() - 1);
            }
            swagger.setBasePath(basePath);
            return swagger;
        }

        public String getFilterClass() {
            return null;
        }
    }
}

