/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.features.swagger.integration;

import com.englishtown.vertx.jersey.integration.JerseyHK2IntegrationTestBase;
import com.englishtown.vertx.promises.RequestOptions;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import org.junit.Test;

public class SwaggerFeatureIntegrationTest
extends JerseyHK2IntegrationTestBase {
    private String BASE_PATH = "http://localhost:8080/rest/";

    public void setUp() throws Exception {
        Field field = ApiListingResource.class.getSuperclass().getDeclaredField("initialized");
        field.setAccessible(true);
        field.set(null, false);
        super.setUp();
    }

    @Test
    public void testSwaggerJson() throws Exception {
        this.runTest("swagger.json", body -> {
            JsonObject json = new JsonObject(body.toString());
            this.assertNotNull(json);
            this.assertEquals("2.0", json.getString("swagger"));
        });
    }

    @Test
    public void testSwaggerYaml() throws Exception {
        this.runTest("swagger.yaml", body -> {
            String yaml = body.toString();
            this.assertFalse(yaml.isEmpty());
            this.assertTrue(yaml.contains("swagger: \"2.0\""));
        });
    }

    private void runTest(String additionalPath, Consumer<Buffer> assertMethod) throws Exception {
        RequestOptions options = new RequestOptions().setPauseResponse(true).addHeader("Origin", "http://test.org");
        this.getWhenHttpClient().requestAbs(HttpMethod.GET, this.BASE_PATH + additionalPath, options).then(response -> {
            this.assertEquals(200L, response.statusCode());
            this.assertEquals("*", response.getHeader("Access-Control-Allow-Origin"));
            return this.getWhenHttpClient().body(response);
        }).then(body -> {
            assertMethod.accept((Buffer)body);
            this.testComplete();
            return null;
        }).otherwise(arg_0 -> ((SwaggerFeatureIntegrationTest)this).onRejected(arg_0));
        this.await();
    }
}

