/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.guice;

import com.englishtown.vertx.jersey.JerseyHandler;
import com.englishtown.vertx.jersey.JerseyServerOptions;
import com.englishtown.vertx.jersey.VertxContainer;
import com.englishtown.vertx.jersey.impl.DefaultJerseyServer;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.jvnet.hk2.guice.bridge.api.GuiceBridge;
import org.jvnet.hk2.guice.bridge.api.GuiceIntoHK2Bridge;
import org.jvnet.hk2.guice.bridge.api.GuiceScope;
import org.jvnet.hk2.guice.bridge.internal.GuiceScopeContext;

public class GuiceJerseyServer
extends DefaultJerseyServer {
    @Inject
    public GuiceJerseyServer(JerseyHandler jerseyHandler, VertxContainer container, Provider<JerseyServerOptions> optionsProvider, ServiceLocator locator, Injector injector) {
        super(jerseyHandler, container, optionsProvider);
        this.initBridge(locator, injector);
    }

    protected void initBridge(ServiceLocator locator, Injector injector) {
        GuiceBridge.getGuiceBridge().initializeGuiceBridge(locator);
        GuiceIntoHK2Bridge guiceBridge = (GuiceIntoHK2Bridge)locator.getService(GuiceIntoHK2Bridge.class, new Annotation[0]);
        guiceBridge.bridgeGuiceInjector(injector);
        this.injectMultibindings(locator, injector);
        ServiceLocatorUtilities.bind((ServiceLocator)locator, (Binder[])new Binder[]{new AbstractBinder(){

            protected void configure() {
                this.bind(GuiceScopeContext.class).to((TypeLiteral)new TypeLiteral<Context<GuiceScope>>(){}).in(Singleton.class);
            }
        }});
    }

    protected void injectMultibindings(ServiceLocator locator, Injector injector) {
        this.injectMultiBindings(locator, injector, (Key<? extends Set<?>>)new Key<Set<ContainerRequestFilter>>(){}, (Type)((Object)ContainerRequestFilter.class));
        this.injectMultiBindings(locator, injector, (Key<? extends Set<?>>)new Key<Set<ContainerResponseFilter>>(){}, (Type)((Object)ContainerResponseFilter.class));
        this.injectMultiBindings(locator, injector, (Key<? extends Set<?>>)new Key<Set<ReaderInterceptor>>(){}, (Type)((Object)ReaderInterceptor.class));
        this.injectMultiBindings(locator, injector, (Key<? extends Set<?>>)new Key<Set<WriterInterceptor>>(){}, (Type)((Object)WriterInterceptor.class));
        this.injectMultiBindings(locator, injector, (Key<? extends Set<?>>)new Key<Set<ModelProcessor>>(){}, (Type)((Object)ModelProcessor.class));
        this.injectMultiBindings(locator, injector, (Key<? extends Set<?>>)new Key<Set<ContainerLifecycleListener>>(){}, (Type)((Object)ContainerLifecycleListener.class));
        this.injectMultiBindings(locator, injector, (Key<? extends Set<?>>)new Key<Set<ApplicationEventListener>>(){}, (Type)((Object)ApplicationEventListener.class));
        this.injectMultiBindings(locator, injector, (Key<? extends Set<?>>)new Key<Set<ExceptionMapper>>(){}, (Type)((Object)ExceptionMapper.class));
    }

    protected void injectMultiBindings(ServiceLocator locator, Injector injector, Key<? extends Set<?>> key, Type type) {
        Set set = (Set)injector.getInstance(key);
        if (set != null && !set.isEmpty()) {
            for (Object obj : set) {
                ServiceLocatorUtilities.addOneConstant((ServiceLocator)locator, obj, null, (Type[])new Type[]{type});
            }
        }
    }
}

