/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.impl;

import com.englishtown.vertx.jersey.WriteStreamOutput;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;

public class DefaultWriteStreamOutput
implements WriteStreamOutput {
    private HttpServerResponse response;
    private Handler<Void> endHandler;

    @Override
    public WriteStreamOutput init(HttpServerResponse response, Handler<Void> endHandler) {
        this.response = response;
        this.endHandler = endHandler;
        return this;
    }

    @Override
    public boolean isResponseSet() {
        return this.response != null;
    }

    @Override
    public void end() {
        this.checkResponseSet();
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        } else {
            this.response.end();
        }
    }

    public WriteStreamOutput write(Buffer data) {
        this.checkResponseSet();
        this.response.write(data);
        return this;
    }

    public WriteStreamOutput setWriteQueueMaxSize(int maxSize) {
        this.checkResponseSet();
        this.response.setWriteQueueMaxSize(maxSize);
        return null;
    }

    public boolean writeQueueFull() {
        this.checkResponseSet();
        return this.response.writeQueueFull();
    }

    public WriteStreamOutput drainHandler(Handler<Void> handler) {
        this.checkResponseSet();
        this.response.drainHandler(handler);
        return this;
    }

    public WriteStreamOutput exceptionHandler(Handler<Throwable> handler) {
        this.checkResponseSet();
        this.response.exceptionHandler(handler);
        return this;
    }

    private void checkResponseSet() {
        if (this.response == null) {
            throw new IllegalStateException("The HttpServerResponse has not been set yet.");
        }
    }
}

