/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.impl;

import com.englishtown.vertx.jersey.WriteStreamOutput;
import com.englishtown.vertx.jersey.inject.VertxPostResponseProcessor;
import com.englishtown.vertx.jersey.inject.VertxResponseProcessor;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

public class VertxResponseWriter
implements ContainerResponseWriter {
    private static final Logger logger = LoggerFactory.getLogger(VertxResponseWriter.class);
    private final HttpServerRequest vertxRequest;
    private final Vertx vertx;
    private final List<VertxResponseProcessor> responseProcessors;
    private final List<VertxPostResponseProcessor> postResponseProcessors;
    private long suspendTimerId;
    private ContainerResponseWriter.TimeoutHandler timeoutHandler;
    private ContainerResponse jerseyResponse;
    private boolean isWriteStream;

    @Inject
    public VertxResponseWriter(HttpServerRequest vertxRequest, Vertx vertx, List<VertxResponseProcessor> responseProcessors, List<VertxPostResponseProcessor> postResponseProcessors) {
        this.vertxRequest = vertxRequest;
        this.vertx = vertx;
        this.responseProcessors = responseProcessors;
        this.postResponseProcessors = postResponseProcessors;
    }

    public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse responseContext) throws ContainerException {
        this.jerseyResponse = responseContext;
        HttpServerResponse response = this.vertxRequest.response();
        response.setStatusCode(responseContext.getStatus());
        response.setStatusMessage(responseContext.getStatusInfo().getReasonPhrase());
        if (contentLength != -1L) {
            response.putHeader("Content-Length", String.valueOf(contentLength));
        }
        for (Map.Entry e : responseContext.getStringHeaders().entrySet()) {
            response.putHeader((String)e.getKey(), (Iterable)e.getValue());
        }
        if (!this.responseProcessors.isEmpty()) {
            for (VertxResponseProcessor processor : this.responseProcessors) {
                processor.process(response, responseContext);
            }
        }
        if (responseContext.isChunked()) {
            response.setChunked(true);
            return new VertxChunkedOutputStream(response);
        }
        if (responseContext.hasEntity() && WriteStreamOutput.class.isAssignableFrom(responseContext.getEntityClass())) {
            WriteStreamOutput writeStreamOutput = (WriteStreamOutput)responseContext.getEntity();
            writeStreamOutput.init(response, (Handler<Void>)((Handler)event -> this.end()));
            this.isWriteStream = true;
            return new NOPOutputStream();
        }
        return new VertxOutputStream(response);
    }

    public boolean suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
        this.timeoutHandler = timeoutHandler;
        if (this.suspendTimerId != 0L) {
            this.vertx.cancelTimer(this.suspendTimerId);
            this.suspendTimerId = 0L;
        }
        if (timeOut <= 0L) {
            return true;
        }
        long ms = timeUnit.toMillis(timeOut);
        this.suspendTimerId = this.vertx.setTimer(ms, id -> {
            if (id == this.suspendTimerId) {
                this.timeoutHandler.onTimeout((ContainerResponseWriter)this);
            }
        });
        return true;
    }

    public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
        if (this.timeoutHandler == null) {
            throw new IllegalStateException("The timeoutHandler is null");
        }
        this.suspend(timeOut, timeUnit, this.timeoutHandler);
    }

    public void commit() {
        if (!this.isWriteStream) {
            this.end();
        }
    }

    protected void end() {
        this.vertxRequest.response().end();
        if (!this.postResponseProcessors.isEmpty()) {
            for (VertxPostResponseProcessor processor : this.postResponseProcessors) {
                processor.process(this.vertxRequest.response(), this.jerseyResponse);
            }
        }
    }

    public void failure(Throwable error) {
        logger.error((Object)error.getMessage(), error);
        HttpServerResponse response = this.vertxRequest.response();
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        response.setStatusCode(status.getStatusCode());
        response.setStatusMessage(status.getReasonPhrase());
        response.end();
    }

    public boolean enableResponseBuffering() {
        return false;
    }

    private static class NOPOutputStream
    extends OutputStream {
        private NOPOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class VertxChunkedOutputStream
    extends OutputStream {
        private final HttpServerResponse response;
        private boolean isClosed;

        private VertxChunkedOutputStream(HttpServerResponse response) {
            this.response = response;
        }

        @Override
        public void write(int b) throws IOException {
            this.checkState();
            Buffer buffer = Buffer.buffer();
            buffer.appendByte((byte)b);
            this.response.write(buffer);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.checkState();
            this.response.write(Buffer.buffer((byte[])b));
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.checkState();
            Buffer buffer = Buffer.buffer();
            if (off == 0 && len == b.length) {
                buffer.appendBytes(b);
            } else {
                buffer.appendBytes(Arrays.copyOfRange(b, off, off + len));
            }
            this.response.write(buffer);
        }

        @Override
        public void close() throws IOException {
            this.isClosed = true;
        }

        void checkState() {
            if (this.isClosed) {
                throw new RuntimeException("Stream is closed");
            }
        }
    }

    private static class VertxOutputStream
    extends OutputStream {
        final HttpServerResponse response;
        Buffer buffer = Buffer.buffer();
        boolean isClosed;

        private VertxOutputStream(HttpServerResponse response) {
            this.response = response;
        }

        @Override
        public void write(int b) throws IOException {
            this.checkState();
            this.buffer.appendByte((byte)b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.checkState();
            this.buffer.appendBytes(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.checkState();
            if (off == 0 && len == b.length) {
                this.buffer.appendBytes(b);
            } else {
                this.buffer.appendBytes(Arrays.copyOfRange(b, off, off + len));
            }
        }

        @Override
        public void flush() throws IOException {
            this.checkState();
            if (this.buffer.length() > 0 && this.response.headers().contains("Content-Length")) {
                this.response.write(this.buffer);
                this.buffer = Buffer.buffer();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.buffer != null && this.buffer.length() > 0) {
                if (!this.response.headers().contains("Content-Length")) {
                    this.response.headers().add("Content-Length", String.valueOf(this.buffer.length()));
                }
                this.response.write(this.buffer);
            }
            this.buffer = null;
            this.isClosed = true;
        }

        void checkState() {
            if (this.isClosed) {
                throw new RuntimeException("Stream is closed");
            }
        }
    }
}

