/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.impl;

import com.englishtown.vertx.jersey.ApplicationHandlerDelegate;
import com.englishtown.vertx.jersey.JerseyOptions;
import com.englishtown.vertx.jersey.VertxContainer;
import com.englishtown.vertx.jersey.impl.DefaultJerseyHandler;
import com.englishtown.vertx.jersey.inject.ContainerResponseWriterProvider;
import com.englishtown.vertx.jersey.inject.VertxRequestProcessor;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

public class DefaultJerseyHandlerTest {
    DefaultJerseyHandler jerseyHandler;
    JsonObject config = new JsonObject();
    List<VertxRequestProcessor> requestProcessors = new ArrayList<VertxRequestProcessor>();
    @Mock
    VertxContainer container;
    @Mock
    JerseyOptions options;
    @Mock
    ApplicationHandlerDelegate applicationHandlerDelegate;
    @Mock
    HttpServerRequest request;
    @Mock
    HttpServerResponse response;
    @Mock
    ServiceLocator serviceLocator;
    @Mock
    Vertx vertx;
    @Mock
    Logger logger;
    @Mock
    Ref<Vertx> vertxRef;
    @Mock
    Ref<Container> containerRef;
    @Mock
    MultiMap headers;
    @Captor
    ArgumentCaptor<Handler<Buffer>> dataHandlerCaptor;
    @Captor
    ArgumentCaptor<Handler<Void>> endHandlerCaptor;
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();

    @Before
    public void setUp() {
        Mockito.when((Object)this.container.getOptions()).thenReturn((Object)this.options);
        Mockito.when((Object)this.container.getVertx()).thenReturn((Object)this.vertx);
        Mockito.when((Object)this.container.getApplicationHandlerDelegate()).thenReturn((Object)this.applicationHandlerDelegate);
        Mockito.when((Object)this.applicationHandlerDelegate.getServiceLocator()).thenReturn((Object)this.serviceLocator);
        Mockito.when((Object)this.options.getMaxBodySize()).thenReturn((Object)1024);
        Mockito.when((Object)this.options.getBaseUri()).thenReturn((Object)URI.create("/test"));
        Mockito.when((Object)this.request.absoluteURI()).thenReturn((Object)URI.create("http://test.englishtown.com/test").toString());
        Mockito.when((Object)this.request.response()).thenReturn((Object)this.response);
        Mockito.when((Object)this.request.headers()).thenReturn((Object)this.headers);
        JsonArray resources = new JsonArray().add("com.englishtown.vertx.jersey.resources");
        this.config.put("resources", resources);
        ContainerResponseWriterProvider provider = (ContainerResponseWriterProvider)Mockito.mock(ContainerResponseWriterProvider.class);
        Mockito.when((Object)provider.get((HttpServerRequest)Matchers.any(HttpServerRequest.class), (ContainerRequest)Matchers.any(ContainerRequest.class))).thenReturn((Object)((ContainerResponseWriter)Mockito.mock(ContainerResponseWriter.class)));
        Mockito.when((Object)((Ref)this.serviceLocator.getService(new TypeLiteral<Ref<Vertx>>(){}.getType(), new Annotation[0]))).thenReturn(this.vertxRef);
        Mockito.when((Object)((Ref)this.serviceLocator.getService(new TypeLiteral<Ref<Container>>(){}.getType(), new Annotation[0]))).thenReturn(this.containerRef);
        this.jerseyHandler = new DefaultJerseyHandler(() -> this.container, provider, this.requestProcessors);
    }

    @Test
    public void testHandle() throws Exception {
        Mockito.when((Object)this.request.method()).thenReturn((Object)HttpMethod.GET);
        Mockito.when((Object)this.request.headers()).thenReturn((Object)((MultiMap)Mockito.mock(MultiMap.class)));
        this.jerseyHandler.handle(this.request);
        ((ApplicationHandlerDelegate)Mockito.verify((Object)this.applicationHandlerDelegate)).handle((ContainerRequest)Matchers.any(ContainerRequest.class));
    }

    @Test
    public void testHandle_JSON_POST() throws Exception {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.add("Content-Type", (Object)"application/json");
        Mockito.when((Object)this.request.method()).thenReturn((Object)HttpMethod.POST);
        Mockito.when((Object)this.request.headers()).thenReturn((Object)new HeadersAdaptor((HttpHeaders)headers));
        this.jerseyHandler.handle(this.request);
        ((HttpServerRequest)Mockito.verify((Object)this.request)).handler((Handler)this.dataHandlerCaptor.capture());
        ((HttpServerRequest)Mockito.verify((Object)this.request)).endHandler((Handler)this.endHandlerCaptor.capture());
        Buffer data = Buffer.buffer((String)"PostBody");
        ((Handler)this.dataHandlerCaptor.getValue()).handle((Object)data);
        ((Handler)this.endHandlerCaptor.getValue()).handle(null);
        ((ApplicationHandlerDelegate)Mockito.verify((Object)this.applicationHandlerDelegate)).handle((ContainerRequest)Matchers.any(ContainerRequest.class));
    }

    @Test
    public void testHandle_RequestProcessors() throws Exception {
        Mockito.when((Object)this.request.headers()).thenReturn((Object)((MultiMap)Mockito.mock(MultiMap.class)));
        Mockito.when((Object)this.request.method()).thenReturn((Object)HttpMethod.GET);
        InputStream inputStream = null;
        VertxRequestProcessor rp1 = (VertxRequestProcessor)Mockito.mock(VertxRequestProcessor.class);
        VertxRequestProcessor rp2 = (VertxRequestProcessor)Mockito.mock(VertxRequestProcessor.class);
        this.requestProcessors.add(rp1);
        this.requestProcessors.add(rp2);
        this.jerseyHandler.handle(this.request, inputStream);
        ((VertxRequestProcessor)Mockito.verify((Object)rp1)).process((HttpServerRequest)Matchers.any(HttpServerRequest.class), (ContainerRequest)Matchers.any(ContainerRequest.class), (Handler)this.endHandlerCaptor.capture());
        ((Handler)this.endHandlerCaptor.getValue()).handle(null);
        ((VertxRequestProcessor)Mockito.verify((Object)rp2)).process((HttpServerRequest)Matchers.any(HttpServerRequest.class), (ContainerRequest)Matchers.any(ContainerRequest.class), (Handler)this.endHandlerCaptor.capture());
        ((Handler)this.endHandlerCaptor.getValue()).handle(null);
        ((ApplicationHandlerDelegate)Mockito.verify((Object)this.applicationHandlerDelegate)).handle((ContainerRequest)Matchers.any(ContainerRequest.class));
    }

    @Test
    public void testHandle_RequestProcessors_Throw() throws Exception {
        Mockito.when((Object)this.request.headers()).thenReturn((Object)((MultiMap)Mockito.mock(MultiMap.class)));
        Mockito.when((Object)this.request.method()).thenReturn((Object)HttpMethod.GET);
        InputStream inputStream = null;
        VertxRequestProcessor rp1 = (VertxRequestProcessor)Mockito.mock(VertxRequestProcessor.class);
        VertxRequestProcessor rp2 = (VertxRequestProcessor)Mockito.mock(VertxRequestProcessor.class);
        Mockito.when((Object)this.response.setStatusCode(Mockito.anyInt())).thenReturn((Object)this.response);
        ((VertxRequestProcessor)Mockito.doThrow(RuntimeException.class).when((Object)rp2)).process((HttpServerRequest)Matchers.any(), (ContainerRequest)Matchers.any(), (Handler)Matchers.any());
        this.requestProcessors.add(rp1);
        this.requestProcessors.add(rp2);
        this.jerseyHandler.handle(this.request, inputStream);
        ((VertxRequestProcessor)Mockito.verify((Object)rp1)).process((HttpServerRequest)Matchers.any(), (ContainerRequest)Matchers.any(), (Handler)this.endHandlerCaptor.capture());
        ((Handler)this.endHandlerCaptor.getValue()).handle(null);
        ((VertxRequestProcessor)Mockito.verify((Object)rp2)).process((HttpServerRequest)Matchers.any(), (ContainerRequest)Matchers.any(), (Handler)Matchers.any());
        ((HttpServerResponse)Mockito.verify((Object)this.response)).setStatusCode(Matchers.eq((int)HttpResponseStatus.INTERNAL_SERVER_ERROR.code()));
        ((HttpServerResponse)Mockito.verify((Object)this.response)).end();
    }

    @Test
    public void testShouldReadData() throws Exception {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.add("Content-Type", (Object)"application/octet-stream");
        Mockito.when((Object)this.request.method()).thenReturn((Object)HttpMethod.GET).thenReturn((Object)HttpMethod.PUT);
        Mockito.when((Object)this.request.headers()).thenReturn((Object)new HeadersAdaptor((HttpHeaders)headers));
        boolean result = this.jerseyHandler.shouldReadData(this.request);
        Assert.assertFalse((boolean)result);
        result = this.jerseyHandler.shouldReadData(this.request);
        Assert.assertFalse((boolean)result);
        headers.clear();
        headers.add("Content-Type", (Object)"text/plain");
        result = this.jerseyHandler.shouldReadData(this.request);
        Assert.assertTrue((boolean)result);
        headers.clear();
        headers.add("Content-Type", (Object)"application/json");
        result = this.jerseyHandler.shouldReadData(this.request);
        Assert.assertTrue((boolean)result);
        headers.clear();
        headers.add("Content-Type", (Object)"application/x-www-form-urlencoded");
        Mockito.when((Object)this.request.method()).thenReturn((Object)HttpMethod.POST);
        result = this.jerseyHandler.shouldReadData(this.request);
        Assert.assertTrue((boolean)result);
        headers.clear();
        headers.add("Content-Type", (Object)"application/xml");
        result = this.jerseyHandler.shouldReadData(this.request);
        Assert.assertTrue((boolean)result);
        headers.clear();
        headers.add("Content-Type", (Object)"application/x-www-form-urlencoded; charset=UTF-8");
        result = this.jerseyHandler.shouldReadData(this.request);
        Assert.assertTrue((boolean)result);
        headers.clear();
        headers.add("Content-Type", (Object)"application/x-www-form-urlencoded");
        Mockito.when((Object)this.request.method()).thenReturn((Object)HttpMethod.PATCH);
        result = this.jerseyHandler.shouldReadData(this.request);
        Assert.assertTrue((boolean)result);
        headers.clear();
        headers.add("Content-Type", (Object)"application/json");
        result = this.jerseyHandler.shouldReadData(this.request);
        Assert.assertTrue((boolean)result);
        headers.clear();
        headers.add("Content-Type", (Object)"application/xml");
        result = this.jerseyHandler.shouldReadData(this.request);
        Assert.assertTrue((boolean)result);
        headers.clear();
        headers.add("Content-Type", (Object)"application/x-www-form-urlencoded; charset=UTF-8");
        result = this.jerseyHandler.shouldReadData(this.request);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testGetAbsoluteURI() throws Exception {
        String absoluteUri = "http://0.0.0.0:80/test";
        String host = "test.englishtown.com";
        String badUrl = "http://test.englishtown.com/test?a=b=c|d=e";
        HttpServerRequest request = (HttpServerRequest)Mockito.mock(HttpServerRequest.class);
        Mockito.when((Object)request.absoluteURI()).thenReturn((Object)absoluteUri).thenThrow(new Throwable[]{new IllegalArgumentException()});
        Mockito.when((Object)request.uri()).thenReturn((Object)badUrl);
        Mockito.when((Object)request.headers()).thenReturn((Object)this.headers);
        Mockito.when((Object)this.headers.get((String)Matchers.eq((Object)"Host"))).thenReturn((Object)host);
        URI uri = this.jerseyHandler.getAbsoluteURI(request);
        Assert.assertEquals((Object)"http://test.englishtown.com/test", (Object)uri.toString());
        uri = this.jerseyHandler.getAbsoluteURI(request);
        Assert.assertEquals((Object)"http://test.englishtown.com/test?a=b%3Dc%7Cd%3De", (Object)uri.toString());
    }

    @Test
    public void testGetBaseURI() throws Exception {
        URI baseUri = URI.create("/test");
        Mockito.when((Object)this.options.getBaseUri()).thenReturn((Object)baseUri);
        URI result = this.jerseyHandler.getBaseUri();
        Assert.assertEquals((Object)baseUri, (Object)result);
    }
}

