/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.impl;

import com.englishtown.vertx.jersey.ApplicationConfigurator;
import com.englishtown.vertx.jersey.JerseyOptions;
import com.englishtown.vertx.jersey.impl.DefaultVertxContainer;
import io.vertx.core.Vertx;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

public class DefaultVertxContainerTest {
    private DefaultVertxContainer container;
    private ServiceLocator locator;
    private List<String> packages = new ArrayList<String>();
    @Mock
    Vertx vertx;
    @Mock
    JerseyOptions options;
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.options.getPackages()).thenReturn(this.packages);
        this.locator = ServiceLocatorFactory.getInstance().create(null);
    }

    @Test
    public void testStart() throws Exception {
        this.packages.add("com.englishtown.vertx.jersey.resources");
        this.container = new DefaultVertxContainer(this.vertx, this.options, this.locator, null);
        this.container.start();
        Assert.assertEquals((Object)this.options, (Object)this.container.getOptions());
        Assert.assertNotNull((Object)this.container.getConfiguration());
        Assert.assertNotNull((Object)this.container.getApplicationHandler());
        Assert.assertNotNull((Object)this.container.getApplicationHandlerDelegate());
    }

    @Test
    public void testStop() throws Exception {
        this.packages.add("com.englishtown.vertx.jersey.resources");
        this.container = new DefaultVertxContainer(this.vertx, this.options, this.locator, null);
        this.container.start();
        this.container.stop();
    }

    @Test
    public void testResourceConfigModifier() throws Exception {
        boolean[] b = new boolean[]{false};
        ApplicationConfigurator configurator = rc -> {
            b[0] = true;
            return rc;
        };
        this.packages.add("com.englishtown.vertx.jersey.resources");
        this.container = new DefaultVertxContainer(this.vertx, this.options, this.locator, configurator);
        this.container.start();
        Assert.assertTrue((boolean)b[0]);
    }

    @Test
    public void testInit_Missing_Resources() throws Exception {
        try {
            this.container = new DefaultVertxContainer(this.vertx, this.options, this.locator, null);
            this.container.start();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"At least one resource package name or component must be specified", (Object)e.getMessage());
        }
    }
}

