/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.impl;

import com.englishtown.vertx.jersey.impl.VertxResponseWriter;
import com.englishtown.vertx.jersey.inject.VertxPostResponseProcessor;
import com.englishtown.vertx.jersey.inject.VertxResponseProcessor;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.HeadersAdaptor;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;

public class VertxResponseWriterTest {
    VertxResponseWriter writer;
    List<VertxResponseProcessor> responseProcessors = new ArrayList<VertxResponseProcessor>();
    List<VertxPostResponseProcessor> postResponseProcessors = new ArrayList<VertxPostResponseProcessor>();
    long timerId = 10L;
    @Mock
    Vertx vertx;
    @Mock
    HttpServerRequest request;
    @Mock
    HttpServerResponse response;
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();

    @Before
    public void setUp() {
        Mockito.when((Object)this.request.response()).thenReturn((Object)this.response);
        Mockito.when((Object)this.vertx.setTimer(Matchers.anyLong(), (Handler)Matchers.any(Handler.class))).thenReturn((Object)this.timerId);
        this.writer = new VertxResponseWriter(this.request, this.vertx, this.responseProcessors, this.postResponseProcessors);
    }

    @Test
    public void testWriteResponseStatusAndHeaders() throws Exception {
        ContainerResponse cr = (ContainerResponse)Mockito.mock(ContainerResponse.class);
        MultivaluedHashMap headers = new MultivaluedHashMap();
        Mockito.when((Object)cr.getStatusInfo()).thenReturn((Object)((Response.StatusType)Mockito.mock(Response.StatusType.class)));
        Mockito.when((Object)cr.getStringHeaders()).thenReturn((Object)headers);
        VertxResponseProcessor processor1 = (VertxResponseProcessor)Mockito.mock(VertxResponseProcessor.class);
        VertxResponseProcessor processor2 = (VertxResponseProcessor)Mockito.mock(VertxResponseProcessor.class);
        this.responseProcessors.add(processor1);
        this.responseProcessors.add(processor2);
        headers.add((Object)"x-test", (Object)"custom header");
        OutputStream outputStream = this.writer.writeResponseStatusAndHeaders(15L, cr);
        Assert.assertNotNull((Object)outputStream);
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatusCode(Matchers.anyInt());
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatusMessage(Matchers.anyString());
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).putHeader(Matchers.anyString(), (Iterable)Mockito.anyListOf(String.class));
        ((VertxResponseProcessor)Mockito.verify((Object)processor1)).process((HttpServerResponse)Matchers.eq((Object)this.response), (ContainerResponse)Matchers.eq((Object)cr));
        ((VertxResponseProcessor)Mockito.verify((Object)processor2)).process((HttpServerResponse)Matchers.eq((Object)this.response), (ContainerResponse)Matchers.eq((Object)cr));
        this.writer.writeResponseStatusAndHeaders(-1L, cr);
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).putHeader(Matchers.anyString(), (Iterable)Mockito.anyListOf(String.class));
    }

    @Test
    public void testWriteResponse_Throw() throws Exception {
        ContainerResponse cr = (ContainerResponse)Mockito.mock(ContainerResponse.class);
        MultivaluedHashMap headers = new MultivaluedHashMap();
        Mockito.when((Object)cr.getStatusInfo()).thenReturn((Object)((Response.StatusType)Mockito.mock(Response.StatusType.class)));
        Mockito.when((Object)cr.getStringHeaders()).thenReturn((Object)headers);
        VertxResponseProcessor processor1 = (VertxResponseProcessor)Mockito.mock(VertxResponseProcessor.class);
        VertxResponseProcessor processor2 = (VertxResponseProcessor)Mockito.mock(VertxResponseProcessor.class);
        this.responseProcessors.add(processor1);
        this.responseProcessors.add(processor2);
        headers.add((Object)"x-test", (Object)"custom header");
        OutputStream outputStream = this.writer.writeResponseStatusAndHeaders(15L, cr);
        Assert.assertNotNull((Object)outputStream);
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatusCode(Matchers.anyInt());
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatusMessage(Matchers.anyString());
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).putHeader(Matchers.anyString(), (Iterable)Mockito.anyListOf(String.class));
        ((VertxResponseProcessor)Mockito.verify((Object)processor1)).process((HttpServerResponse)Matchers.eq((Object)this.response), (ContainerResponse)Matchers.eq((Object)cr));
        ((VertxResponseProcessor)Mockito.verify((Object)processor2)).process((HttpServerResponse)Matchers.eq((Object)this.response), (ContainerResponse)Matchers.eq((Object)cr));
        this.writer.writeResponseStatusAndHeaders(-1L, cr);
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).putHeader(Matchers.anyString(), (Iterable)Mockito.anyListOf(String.class));
    }

    @Test
    public void testWrite() throws Exception {
        ContainerResponse cr = (ContainerResponse)Mockito.mock(ContainerResponse.class);
        MultivaluedHashMap headers = new MultivaluedHashMap();
        Mockito.when((Object)cr.getStatusInfo()).thenReturn((Object)((Response.StatusType)Mockito.mock(Response.StatusType.class)));
        Mockito.when((Object)cr.getStringHeaders()).thenReturn((Object)headers);
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        HeadersAdaptor vertxHeaders = new HeadersAdaptor((HttpHeaders)httpHeaders);
        vertxHeaders.add("Content-Length", "12");
        Mockito.when((Object)this.response.headers()).thenReturn((Object)vertxHeaders);
        OutputStream outputStream = this.writer.writeResponseStatusAndHeaders(12L, cr);
        outputStream.write("callback".getBytes());
        outputStream.write(40);
        outputStream.flush();
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).write((Buffer)Matchers.any(Buffer.class));
        byte[] buffer = new byte[1024];
        buffer[0] = "{".getBytes()[0];
        buffer[1] = "}".getBytes()[0];
        outputStream.write(buffer, 0, 2);
        outputStream.write(41);
        outputStream.flush();
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).write((Buffer)Matchers.any(Buffer.class));
        outputStream.write(";".getBytes());
        outputStream.close();
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)3))).write((Buffer)Matchers.any(Buffer.class));
        try {
            outputStream.write("fail".getBytes());
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testWrite_Chunked() throws Exception {
        ContainerResponse cr = (ContainerResponse)Mockito.mock(ContainerResponse.class);
        MultivaluedHashMap headers = new MultivaluedHashMap();
        Mockito.when((Object)cr.getStatusInfo()).thenReturn((Object)((Response.StatusType)Mockito.mock(Response.StatusType.class)));
        Mockito.when((Object)cr.getStringHeaders()).thenReturn((Object)headers);
        Mockito.when((Object)cr.isChunked()).thenReturn((Object)true);
        OutputStream outputStream = this.writer.writeResponseStatusAndHeaders(-1L, cr);
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setChunked(Matchers.eq((boolean)true));
        outputStream.write("Chunked data".getBytes());
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).write((Buffer)Matchers.any(Buffer.class));
        outputStream.flush();
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).write((Buffer)Matchers.any(Buffer.class));
        outputStream.write("Chunked data".getBytes());
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).write((Buffer)Matchers.any(Buffer.class));
        outputStream.write("Chunked data".getBytes());
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)3))).write((Buffer)Matchers.any(Buffer.class));
        outputStream.write("Final chunked data".getBytes());
        outputStream.close();
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)4))).write((Buffer)Matchers.any(Buffer.class));
        try {
            outputStream.write("fail".getBytes());
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testSuspend() throws Exception {
        ContainerResponseWriter.TimeoutHandler timeoutHandler = (ContainerResponseWriter.TimeoutHandler)Mockito.mock(ContainerResponseWriter.TimeoutHandler.class);
        boolean result = this.writer.suspend(10L, TimeUnit.SECONDS, timeoutHandler);
        Assert.assertTrue((boolean)result);
        ((Vertx)Mockito.verify((Object)this.vertx, (VerificationMode)Mockito.times((int)1))).setTimer(Matchers.anyLong(), (Handler)Matchers.any(Handler.class));
        result = this.writer.suspend(0L, TimeUnit.SECONDS, timeoutHandler);
        Assert.assertTrue((boolean)result);
        ((Vertx)Mockito.verify((Object)this.vertx, (VerificationMode)Mockito.times((int)1))).setTimer(Matchers.anyLong(), (Handler)Matchers.any(Handler.class));
        result = this.writer.suspend(10L, TimeUnit.SECONDS, timeoutHandler);
        Assert.assertTrue((boolean)result);
        ((Vertx)Mockito.verify((Object)this.vertx, (VerificationMode)Mockito.times((int)2))).setTimer(Matchers.anyLong(), (Handler)Matchers.any(Handler.class));
    }

    @Test
    public void testSetSuspendTimeout() throws Exception {
        ContainerResponseWriter.TimeoutHandler timeoutHandler = (ContainerResponseWriter.TimeoutHandler)Mockito.mock(ContainerResponseWriter.TimeoutHandler.class);
        try {
            this.writer.setSuspendTimeout(10L, TimeUnit.SECONDS);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.writer.suspend(0L, TimeUnit.SECONDS, timeoutHandler);
        this.writer.setSuspendTimeout(5L, TimeUnit.MINUTES);
        ((Vertx)Mockito.verify((Object)this.vertx, (VerificationMode)Mockito.times((int)1))).setTimer(Matchers.anyLong(), (Handler)Matchers.any(Handler.class));
    }

    @Test
    public void testCommit() throws Exception {
        VertxPostResponseProcessor processor1 = (VertxPostResponseProcessor)Mockito.mock(VertxPostResponseProcessor.class);
        VertxPostResponseProcessor processor2 = (VertxPostResponseProcessor)Mockito.mock(VertxPostResponseProcessor.class);
        this.postResponseProcessors.add(processor1);
        this.postResponseProcessors.add(processor2);
        this.writer.commit();
        ((HttpServerResponse)Mockito.verify((Object)this.response)).end();
        ((VertxPostResponseProcessor)Mockito.verify((Object)processor1)).process((HttpServerResponse)Matchers.eq((Object)this.response), (ContainerResponse)Matchers.any(ContainerResponse.class));
        ((VertxPostResponseProcessor)Mockito.verify((Object)processor2)).process((HttpServerResponse)Matchers.eq((Object)this.response), (ContainerResponse)Matchers.any(ContainerResponse.class));
    }

    @Test
    public void testFailure() throws Exception {
        Throwable error = (Throwable)Mockito.mock(Throwable.class);
        this.writer.failure(error);
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatusCode(Matchers.eq((int)500));
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setStatusMessage((String)Matchers.eq((Object)"Internal Server Error"));
        ((HttpServerResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).end();
    }

    @Test
    public void testEnableResponseBuffering() throws Exception {
        boolean result = this.writer.enableResponseBuffering();
        Assert.assertFalse((boolean)result);
    }
}

