/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.integration;

import com.englishtown.vertx.jersey.integration.GuiceTestServiceLocator;
import com.englishtown.vertx.jersey.integration.HK2TestServiceLocator;
import com.englishtown.vertx.jersey.integration.JerseyIntegrationTestBase;
import com.englishtown.vertx.jersey.integration.TestServiceLocator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import java.util.List;
import org.junit.Test;

public abstract class IntegrationTests
extends JerseyIntegrationTestBase {
    private String host = "localhost";
    private int port = 8080;

    protected IntegrationTests(TestServiceLocator locator) {
        super(locator);
    }

    private void verifyResponse(HttpClientResponse response, int status, String contentType, String expected) {
        this.assertEquals(status, response.statusCode());
        this.assertEquals(contentType, response.headers().get("Content-Type"));
        if (expected != null) {
            response.bodyHandler(body -> {
                String result = body.toString("UTF-8");
                this.assertEquals(expected, result);
                this.testComplete();
            });
        } else {
            this.testComplete();
        }
    }

    @Test
    public void test_getJson() throws Exception {
        HttpClientRequest request = this.httpClient.request(HttpMethod.GET, this.port, this.host, "/rest/test/json", response -> this.verifyResponse((HttpClientResponse)response, 200, "application/json", "{}"));
        request.end();
        this.await();
    }

    @Test
    public void test_getJsonp() throws Exception {
        String contentType = "application/javascript";
        HttpClientRequest request = this.httpClient.request(HttpMethod.GET, this.port, this.host, "/rest/test/json?cb=foo_cb", response -> this.verifyResponse((HttpClientResponse)response, 200, "application/javascript", "foo_cb({})"));
        request.headers().add("Accept", "application/javascript");
        request.end();
        this.await();
    }

    @Test
    public void test_getHtml() throws Exception {
        HttpClientRequest request = this.httpClient.request(HttpMethod.GET, this.port, this.host, "/rest/test/html", response -> this.verifyResponse((HttpClientResponse)response, 200, "text/html", null));
        request.end();
        this.await();
    }

    @Test
    public void test_postJson() throws Exception {
        HttpClientRequest request = this.httpClient.request(HttpMethod.POST, this.port, this.host, "/rest/test/json", response -> this.verifyResponse((HttpClientResponse)response, 200, "application/json", "{\"name\":\"async response\"}"));
        request.headers().add("Content-Type", "application/json");
        request.end("{\"name\":\"post\"}");
        this.await();
    }

    @Test
    public void test_postText() throws Exception {
        String body = "Hello world!";
        HttpClientRequest request = this.httpClient.request(HttpMethod.POST, this.port, this.host, "/rest/test/text", response -> this.verifyResponse((HttpClientResponse)response, 200, "text/plain", body));
        request.headers().add("Content-Type", "text/plain");
        request.end(body);
        this.await();
    }

    @Test
    public void test_postXml() throws Exception {
        String body = "<a></a>";
        HttpClientRequest request = this.httpClient.request(HttpMethod.POST, this.port, this.host, "/rest/test/xml", response -> this.verifyResponse((HttpClientResponse)response, 200, "text/xml", body));
        request.headers().add("Content-Type", "text/plain");
        request.end(body);
        this.await();
    }

    @Test
    public void test_getChunked() throws Exception {
        HttpClientRequest request = this.httpClient.request(HttpMethod.GET, this.port, this.host, "/rest/test/chunked", response -> this.verifyResponse((HttpClientResponse)response, 200, "text/plain", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"));
        request.end();
        this.await();
    }

    @Test
    public void test_getHeaders() throws Exception {
        HttpClientRequest request = this.httpClient.request(HttpMethod.GET, this.port, this.host, "/rest/test/headers", response -> {
            this.assertEquals(HttpResponseStatus.OK.code(), response.statusCode());
            List headers = response.headers().getAll("x-test-1");
            this.assertEquals(2L, headers.size());
            this.assertEquals("a", headers.get(0));
            this.assertEquals("b", headers.get(1));
            headers = response.headers().getAll("x-test-2");
            this.assertEquals(1L, headers.size());
            this.assertEquals("c", headers.get(0));
            this.assertEquals("a", response.getHeader("x-test-1"));
            this.assertEquals("c", response.getHeader("x-test-2"));
            this.testComplete();
        });
        request.end();
        this.await();
    }

    public static class Guice
    extends IntegrationTests {
        public Guice() {
            super(new GuiceTestServiceLocator());
        }
    }

    public static class HK2
    extends IntegrationTests {
        public HK2() {
            super(new HK2TestServiceLocator());
        }
    }
}

