/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.promises.impl;

import com.englishtown.promises.Done;
import com.englishtown.promises.When;
import com.englishtown.promises.WhenFactory;
import com.englishtown.vertx.jersey.JerseyOptions;
import com.englishtown.vertx.jersey.JerseyServer;
import com.englishtown.vertx.jersey.JerseyServerOptions;
import com.englishtown.vertx.jersey.promises.impl.DefaultWhenJerseyServer;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import javax.inject.Provider;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

public class DefaultWhenJerseyServerTest {
    private DefaultWhenJerseyServer whenJerseyServer;
    private Done<JerseyServer> done = new Done();
    @Mock
    Provider<JerseyServer> serverProvider;
    @Mock
    JerseyServer server;
    @Mock
    Vertx vertx;
    @Mock
    AsyncResult<HttpServer> result;
    @Captor
    ArgumentCaptor<Handler<AsyncResult<HttpServer>>> handlerCaptor;
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();

    @Before
    public void setUp() {
        When when = WhenFactory.createSync();
        Mockito.when((Object)((JerseyServer)this.serverProvider.get())).thenReturn((Object)this.server);
        this.whenJerseyServer = new DefaultWhenJerseyServer(this.vertx, this.serverProvider, when);
    }

    @Test
    public void testCreateServer_Success() throws Exception {
        Mockito.when((Object)this.result.succeeded()).thenReturn((Object)true);
        this.whenJerseyServer.createServer().then(this.done.onFulfilled, this.done.onRejected);
        ((JerseyServer)Mockito.verify((Object)this.server)).start((JerseyServerOptions)Matchers.any(), (JerseyOptions)Matchers.any(), (Handler)this.handlerCaptor.capture());
        ((Handler)this.handlerCaptor.getValue()).handle(this.result);
        this.done.assertFulfilled();
    }

    @Test
    public void testCreateServer_Fail() throws Exception {
        Mockito.when((Object)this.result.succeeded()).thenReturn((Object)false);
        this.whenJerseyServer.createServer().then(this.done.onFulfilled, this.done.onRejected);
        ((JerseyServer)Mockito.verify((Object)this.server)).start((JerseyServerOptions)Matchers.any(), (JerseyOptions)Matchers.any(), (Handler)this.handlerCaptor.capture());
        ((Handler)this.handlerCaptor.getValue()).handle(this.result);
        this.done.assertRejected();
    }
}

