/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.resources;

import com.englishtown.vertx.jersey.integration.MyObject;
import io.vertx.core.Vertx;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.ChunkedOutput;
import org.glassfish.jersey.server.JSONP;

@Path(value="test")
public class TestResource {
    public static final String HEADER_TEST1 = "x-test-1";
    public static final String HEADER_TEST2 = "x-test-2";

    @GET
    @Produces(value={"text/plain"})
    public String getHelloWorld() {
        return "Hello world";
    }

    @GET
    @JSONP(queryParam="cb")
    @Path(value="json")
    @Produces(value={"application/json", "application/javascript"})
    public String getJson() {
        return "{}";
    }

    @GET
    @Path(value="html")
    @Produces(value={"text/html"})
    public Response getHtml() throws Exception {
        URI uri = this.getClass().getResource("/web/index.html").toURI();
        File file = new File(uri);
        if (!file.exists()) {
            throw new RuntimeException("File web/index.html does not exist");
        }
        return Response.ok((Object)file).build();
    }

    @POST
    @Path(value="json")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void postJson(MyObject obj, @Suspended AsyncResponse response, @Context Vertx vertx) {
        vertx.runOnContext(aVoid -> {
            if (obj == null) {
                throw new RuntimeException();
            }
            MyObject obj2 = new MyObject();
            obj2.setName("async response");
            response.resume((Object)obj2);
        });
    }

    @POST
    @Path(value="text")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public void postText(String body, @Suspended AsyncResponse response, @Context Vertx vertx) {
        vertx.runOnContext(aVoid -> {
            if (body == null) {
                throw new RuntimeException();
            }
            response.resume((Object)body);
        });
    }

    @POST
    @Path(value="xml")
    @Consumes(value={"text/xml", "application/xml"})
    @Produces(value={"text/plain"})
    public void postXml(String body, @Suspended AsyncResponse response, @Context Vertx vertx) {
        vertx.runOnContext(aVoid -> {
            if (body == null) {
                throw new RuntimeException();
            }
            response.resume((Object)body);
        });
    }

    @GET
    @Path(value="chunked")
    @Produces(value={"text/plain"})
    public void getChunked(@Suspended AsyncResponse response, @Context Vertx vertx) {
        vertx.runOnContext(aVoid1 -> {
            ChunkedOutput chunkedOutput = new ChunkedOutput(String.class);
            response.resume((Object)chunkedOutput);
            vertx.runOnContext(aVoid2 -> {
                String s = "aaaaaaaaaa";
                try {
                    chunkedOutput.write((Object)s);
                    chunkedOutput.write((Object)s);
                    chunkedOutput.write((Object)s);
                    chunkedOutput.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        });
    }

    @GET
    @Path(value="headers")
    @Produces(value={"text/plain"})
    public Response getHeaders() {
        return Response.ok().entity((Object)"OK").header(HEADER_TEST1, (Object)"a").header(HEADER_TEST1, (Object)"b").header(HEADER_TEST2, (Object)"c").build();
    }
}

