/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.impl;

import com.englishtown.vertx.jersey.JerseyOptions;
import com.englishtown.vertx.jersey.JerseyServerOptions;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;

public class DefaultJerseyOptions
implements JerseyOptions,
JerseyServerOptions {
    public static final String CONFIG_HOST = "host";
    public static final String CONFIG_PORT = "port";
    public static final String CONFIG_SSL = "ssl";
    public static final String CONFIG_JKS_OPTIONS = "jks_options";
    public static final String CONFIG_RECEIVE_BUFFER_SIZE = "receive_buffer_size";
    public static final String CONFIG_BACKLOG_SIZE = "backlog_size";
    public static final String CONFIG_RESOURCE_CONFIG = "resource_config";
    public static final String CONFIG_PROPERTIES = "properties";
    public static final String CONFIG_COMPRESSION_SUPPORTED = "compression_supported";
    public static final String CONFIG_BASE_PATH = "base_path";
    public static final String CONFIG_MAX_BODY_SIZE = "max_body_size";
    public static final String CONFIG_RESOURCES = "resources";
    public static final String CONFIG_PACKAGES = "packages";
    public static final String CONFIG_FEATURES = "features";
    public static final String CONFIG_COMPONENTS = "components";
    public static final String CONFIG_BINDERS = "binders";
    public static final String CONFIG_INSTANCES = "instances";
    public static final int DEFAULT_MAX_BODY_SIZE = 1024000;
    private JsonObject config;
    private HttpServerOptions serverOptions;

    @Inject
    public DefaultJerseyOptions(Vertx vertx) {
        this(DefaultJerseyOptions.getConfig(vertx));
    }

    public DefaultJerseyOptions(JsonObject config) {
        this.config = config;
    }

    private static JsonObject getConfig(Vertx vertx) {
        JsonObject config = vertx.getOrCreateContext().config();
        return config.getJsonObject("jersey", config);
    }

    @Override
    public List<String> getPackages() {
        ArrayList<String> list = new ArrayList<String>();
        Consumer<JsonArray> reader = array -> {
            if (array != null && !array.isEmpty()) {
                for (int i = 0; i < array.size(); ++i) {
                    list.add(array.getString(i));
                }
            }
        };
        JsonArray resources = this.config.getJsonArray(CONFIG_RESOURCES, null);
        JsonArray packages = this.config.getJsonArray(CONFIG_PACKAGES, null);
        reader.accept(resources);
        reader.accept(packages);
        return list;
    }

    @Override
    public Map<String, Object> getProperties() {
        JsonObject json = null;
        JsonObject tmp = this.config.getJsonObject(CONFIG_PROPERTIES);
        if (tmp != null) {
            json = tmp;
        }
        if ((tmp = this.config.getJsonObject(CONFIG_RESOURCE_CONFIG)) != null) {
            if (json == null) {
                json = tmp;
            } else {
                json.mergeIn(tmp);
            }
        }
        return json == null ? null : json.getMap();
    }

    @Override
    public Set<Class<?>> getComponents() {
        HashSet set = new HashSet();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Consumer<JsonArray> reader = array -> {
            if (array != null && array.size() > 0) {
                for (int i = 0; i < array.size(); ++i) {
                    try {
                        set.add(cl.loadClass(array.getString(i)));
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        JsonArray features = this.config.getJsonArray(CONFIG_FEATURES, null);
        JsonArray components = this.config.getJsonArray(CONFIG_COMPONENTS, null);
        reader.accept(features);
        reader.accept(components);
        return set;
    }

    @Override
    public Set<Object> getInstances() {
        HashSet<Object> set = new HashSet<Object>();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Consumer<JsonArray> reader = array -> {
            if (array != null && array.size() > 0) {
                for (int i = 0; i < array.size(); ++i) {
                    try {
                        Class<?> clazz = cl.loadClass(array.getString(i));
                        set.add(clazz.newInstance());
                        continue;
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        JsonArray binders = this.config.getJsonArray(CONFIG_BINDERS, null);
        JsonArray instances = this.config.getJsonArray(CONFIG_INSTANCES, null);
        reader.accept(binders);
        reader.accept(instances);
        return set;
    }

    public String getHost() {
        return this.config.getString(CONFIG_HOST, "0.0.0.0");
    }

    public int getPort() {
        return this.config.getInteger(CONFIG_PORT, Integer.valueOf(80));
    }

    public boolean getSSL() {
        return this.config.getBoolean(CONFIG_SSL, Boolean.valueOf(false));
    }

    public JksOptions getKeyStoreOptions() {
        JsonObject json = this.config.getJsonObject(CONFIG_JKS_OPTIONS);
        return json == null ? null : new JksOptions(json);
    }

    public Integer getReceiveBufferSize() {
        return this.config.getInteger(CONFIG_RECEIVE_BUFFER_SIZE);
    }

    public int getAcceptBacklog() {
        return this.config.getInteger(CONFIG_BACKLOG_SIZE, Integer.valueOf(10000));
    }

    @Override
    public URI getBaseUri() {
        String basePath = this.config.getString(CONFIG_BASE_PATH, "/");
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        return URI.create(basePath);
    }

    @Override
    public int getMaxBodySize() {
        return this.config.getInteger(CONFIG_MAX_BODY_SIZE, Integer.valueOf(1024000));
    }

    public boolean getCompressionSupported() {
        return this.config.getBoolean(CONFIG_COMPRESSION_SUPPORTED, Boolean.valueOf(false));
    }

    @Override
    public HttpServerOptions getServerOptions() {
        if (this.serverOptions == null) {
            this.serverOptions = this.createServerOptions();
        }
        return this.serverOptions;
    }

    protected HttpServerOptions createServerOptions() {
        Integer receiveBufferSize;
        HttpServerOptions serverOptions = new HttpServerOptions().setHost(this.getHost()).setPort(this.getPort()).setAcceptBacklog(this.getAcceptBacklog()).setCompressionSupported(this.getCompressionSupported());
        if (this.getSSL()) {
            serverOptions.setSsl(true);
        }
        if (this.getKeyStoreOptions() != null) {
            serverOptions.setKeyStoreOptions(this.getKeyStoreOptions());
        }
        if ((receiveBufferSize = this.getReceiveBufferSize()) != null && receiveBufferSize > 0) {
            serverOptions.setReceiveBufferSize(receiveBufferSize.intValue());
        }
        return serverOptions;
    }
}

