/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.promises.impl;

import com.englishtown.promises.Deferred;
import com.englishtown.promises.Promise;
import com.englishtown.promises.When;
import com.englishtown.vertx.jersey.JerseyOptions;
import com.englishtown.vertx.jersey.JerseyServer;
import com.englishtown.vertx.jersey.JerseyServerOptions;
import com.englishtown.vertx.jersey.inject.Nullable;
import com.englishtown.vertx.jersey.promises.WhenJerseyServer;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import javax.inject.Inject;
import javax.inject.Provider;

public class DefaultWhenJerseyServer
implements WhenJerseyServer {
    private final Vertx vertx;
    private final Provider<JerseyServer> jerseyServerProvider;
    private final When when;

    @Inject
    public DefaultWhenJerseyServer(Vertx vertx, Provider<JerseyServer> jerseyServerProvider, When when) {
        this.vertx = vertx;
        this.jerseyServerProvider = jerseyServerProvider;
        this.when = when;
    }

    @Override
    public Promise<JerseyServer> createServer(@Nullable JerseyServerOptions options, @Nullable JerseyOptions jerseyOptions) {
        Deferred d = this.when.defer();
        try {
            JerseyServer jerseyServer = (JerseyServer)this.jerseyServerProvider.get();
            jerseyServer.start(options, jerseyOptions, (Handler<AsyncResult<HttpServer>>)((Handler)result -> {
                if (result.succeeded()) {
                    d.resolve((Object)jerseyServer);
                } else {
                    d.reject(result.cause());
                }
            }));
        }
        catch (RuntimeException e) {
            d.reject((Throwable)e);
        }
        return d.getPromise();
    }

    @Override
    public Promise<String> createServerSimple() {
        return this.createServer().then(jerseyServer -> this.when.resolve((Object)""));
    }
}

