(ns libmooncat.ethereum.eth-util
  (:require
   [clojure.string :as str]
   [libmooncat.util :as util])
  #?(:clj
     (:import
      [org.web3j.utils Numeric])))


(def zeros64 (str/join (repeat 64 "0")))

(defn left-pad-hex-to-32-bytes [hex]
  (str (subs zeros64 (count hex)) hex))

(defn right-pad-hex-to-32-bytes [hex]
  (str hex (subs zeros64 (count hex))))

(defn left-pad-hex [hex byte-count]
  (let [zeros (subs zeros64 (- 64 (* 2 byte-count)))]
    (str (subs zeros (count hex)) hex)))

(defn number->hex [x]
  (let [s (str x)]
    #?(:clj (.toString (BigInteger. s) 16)
       :cljs (.toString (js/BigInt s) 16))))

(defn encode-uint [bit-count x]
  (let [byte-count (quot bit-count 8)]
    (left-pad-hex (number->hex x) byte-count)))

;; (def +eth-to-wei-factor+
;;   #?(:clj (BigDecimal. "1000000000000000000")
;;      :cljs  (js/BigInt "1000000000000000000")))

;; (defn eth->wei-hex [x]
;;   #?(:clj (to-uint256 (.toBigInteger (* (BigDecimal. x) +eth-to-wei-factor+)))
;;      ));;:cljs (left-pad-hex-to-32-bytes (number->hex (* +eth-to-wei-factor+))


(defn extract-bytes5 [hex-word]
  (str "0x" (subs hex-word 0 10)))

(defn extract-address [hex-word]
  (str "0x" (subs hex-word 24)))

(defn extract-bytes-to-string [hex-word]
  (when-not (re-matches #"^0+$" hex-word)
    #?(:clj (String. (Numeric/hexStringToByteArray (str/replace hex-word #"(00)+$" "")) "UTF-8"))))

(defn get-word [hex-word word-index]
  (let [hex (util/clean-hex-prefix hex-word)
        i (* 64 word-index)]
    (subs hex i (+ 64 i))))
