(ns libmooncat.data.contracts)

(def mooncatrescue
  {:address "0x60cd862c9c687a9de49aecdc3a99b74a4fc54ab6"
   :abi "[{\"constant\":false,\"inputs\":[{\"name\":\"catId\",\"type\":\"bytes5\"},{\"name\":\"price\",\"type\":\"uint256\"}],\"name\":\"makeAdoptionOffer\",\"outputs\":[],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"name\",\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[],\"name\":\"activate\",\"outputs\":[],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"remainingGenesisCats\",\"outputs\":[{\"name\":\"\",\"type\":\"uint16\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"totalSupply\",\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"remainingCats\",\"outputs\":[{\"name\":\"\",\"type\":\"uint16\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"catId\",\"type\":\"bytes5\"}],\"name\":\"acceptAdoptionOffer\",\"outputs\":[],\"payable\":true,\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"mode\",\"outputs\":[{\"name\":\"\",\"type\":\"uint8\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"catId\",\"type\":\"bytes5\"}],\"name\":\"getCatDetails\",\"outputs\":[{\"name\":\"id\",\"type\":\"bytes5\"},{\"name\":\"owner\",\"type\":\"address\"},{\"name\":\"name\",\"type\":\"bytes32\"},{\"name\":\"onlyOfferTo\",\"type\":\"address\"},{\"name\":\"offerPrice\",\"type\":\"uint256\"},{\"name\":\"requester\",\"type\":\"address\"},{\"name\":\"requestPrice\",\"type\":\"uint256\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"decimals\",\"outputs\":[{\"name\":\"\",\"type\":\"uint8\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"getCatOwners\",\"outputs\":[{\"name\":\"\",\"type\":\"address[]\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"\",\"type\":\"bytes5\"}],\"name\":\"catOwners\",\"outputs\":[{\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[],\"name\":\"withdraw\",\"outputs\":[],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"name\":\"rescueOrder\",\"outputs\":[{\"name\":\"\",\"type\":\"bytes5\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"seed\",\"type\":\"bytes32\"}],\"name\":\"rescueCat\",\"outputs\":[{\"name\":\"\",\"type\":\"bytes5\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"catId\",\"type\":\"bytes5\"}],\"name\":\"cancelAdoptionOffer\",\"outputs\":[],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"getCatIds\",\"outputs\":[{\"name\":\"\",\"type\":\"bytes5[]\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"\",\"type\":\"address\"}],\"name\":\"balanceOf\",\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"getCatNames\",\"outputs\":[{\"name\":\"\",\"type\":\"bytes32[]\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"catId\",\"type\":\"bytes5\"},{\"name\":\"catName\",\"type\":\"bytes32\"}],\"name\":\"nameCat\",\"outputs\":[],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[],\"name\":\"activateInTestMode\",\"outputs\":[],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"\",\"type\":\"bytes5\"}],\"name\":\"adoptionOffers\",\"outputs\":[{\"name\":\"exists\",\"type\":\"bool\"},{\"name\":\"catId\",\"type\":\"bytes5\"},{\"name\":\"seller\",\"type\":\"address\"},{\"name\":\"price\",\"type\":\"uint256\"},{\"name\":\"onlyOfferTo\",\"type\":\"address\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"\",\"type\":\"bytes5\"}],\"name\":\"catNames\",\"outputs\":[{\"name\":\"\",\"type\":\"bytes32\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"symbol\",\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"getCatRequestPrices\",\"outputs\":[{\"name\":\"\",\"type\":\"uint256[]\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"catId\",\"type\":\"bytes5\"}],\"name\":\"cancelAdoptionRequest\",\"outputs\":[],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[],\"name\":\"disableBeforeActivation\",\"outputs\":[],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[],\"name\":\"addGenesisCatGroup\",\"outputs\":[],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"catId\",\"type\":\"bytes5\"},{\"name\":\"price\",\"type\":\"uint256\"},{\"name\":\"to\",\"type\":\"address\"}],\"name\":\"makeAdoptionOfferToAddress\",\"outputs\":[],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"searchSeed\",\"outputs\":[{\"name\":\"\",\"type\":\"bytes32\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"imageGenerationCodeMD5\",\"outputs\":[{\"name\":\"\",\"type\":\"bytes16\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"\",\"type\":\"bytes5\"}],\"name\":\"adoptionRequests\",\"outputs\":[{\"name\":\"exists\",\"type\":\"bool\"},{\"name\":\"catId\",\"type\":\"bytes5\"},{\"name\":\"requester\",\"type\":\"address\"},{\"name\":\"price\",\"type\":\"uint256\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"catId\",\"type\":\"bytes5\"}],\"name\":\"acceptAdoptionRequest\",\"outputs\":[],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"getCatOfferPrices\",\"outputs\":[{\"name\":\"\",\"type\":\"uint256[]\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"catId\",\"type\":\"bytes5\"}],\"name\":\"makeAdoptionRequest\",\"outputs\":[],\"payable\":true,\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"rescueIndex\",\"outputs\":[{\"name\":\"\",\"type\":\"uint16\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"\",\"type\":\"address\"}],\"name\":\"pendingWithdrawals\",\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"payable\":false,\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"catId\",\"type\":\"bytes5\"},{\"name\":\"to\",\"type\":\"address\"}],\"name\":\"giveCat\",\"outputs\":[],\"payable\":false,\"type\":\"function\"},{\"inputs\":[],\"payable\":true,\"type\":\"constructor\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"name\":\"to\",\"type\":\"address\"},{\"indexed\":true,\"name\":\"catId\",\"type\":\"bytes5\"}],\"name\":\"CatRescued\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"name\":\"catId\",\"type\":\"bytes5\"},{\"indexed\":false,\"name\":\"catName\",\"type\":\"bytes32\"}],\"name\":\"CatNamed\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"name\":\"from\",\"type\":\"address\"},{\"indexed\":true,\"name\":\"to\",\"type\":\"address\"},{\"indexed\":false,\"name\":\"value\",\"type\":\"uint256\"}],\"name\":\"Transfer\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"name\":\"catId\",\"type\":\"bytes5\"},{\"indexed\":false,\"name\":\"price\",\"type\":\"uint256\"},{\"indexed\":true,\"name\":\"from\",\"type\":\"address\"},{\"indexed\":true,\"name\":\"to\",\"type\":\"address\"}],\"name\":\"CatAdopted\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"name\":\"catId\",\"type\":\"bytes5\"},{\"indexed\":false,\"name\":\"price\",\"type\":\"uint256\"},{\"indexed\":true,\"name\":\"toAddress\",\"type\":\"address\"}],\"name\":\"AdoptionOffered\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"name\":\"catId\",\"type\":\"bytes5\"}],\"name\":\"AdoptionOfferCancelled\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"name\":\"catId\",\"type\":\"bytes5\"},{\"indexed\":false,\"name\":\"price\",\"type\":\"uint256\"},{\"indexed\":true,\"name\":\"from\",\"type\":\"address\"}],\"name\":\"AdoptionRequested\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"name\":\"catId\",\"type\":\"bytes5\"}],\"name\":\"AdoptionRequestCancelled\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"name\":\"catIds\",\"type\":\"bytes5[16]\"}],\"name\":\"GenesisCatsAdded\",\"type\":\"event\"}]"})

(def deprecated-unofficial-mooncat-wrapper
  {:address "0x7c40c393dc0f283f318791d746d894ddd3693572"
   :abi "[{\"inputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"constructor\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"owner\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"approved\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"Approval\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"owner\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"operator\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"bool\",\"name\":\"approved\",\"type\":\"bool\"}],\"name\":\"ApprovalForAll\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"from\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"to\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"Transfer\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"bytes5\",\"name\":\"catId\",\"type\":\"bytes5\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"tokenID\",\"type\":\"uint256\"}],\"name\":\"Unwrapped\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"bytes5\",\"name\":\"catId\",\"type\":\"bytes5\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"tokenID\",\"type\":\"uint256\"}],\"name\":\"Wrapped\",\"type\":\"event\"},{\"inputs\":[],\"name\":\"_baseURI\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"bytes5\",\"name\":\"\",\"type\":\"bytes5\"}],\"name\":\"_catIDToTokenID\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"_moonCats\",\"outputs\":[{\"internalType\":\"contract MoonCatsRescue\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"_owner\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"name\":\"_tokenIDToCatID\",\"outputs\":[{\"internalType\":\"bytes5\",\"name\":\"\",\"type\":\"bytes5\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"to\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"approve\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"owner\",\"type\":\"address\"}],\"name\":\"balanceOf\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"baseURI\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"getApproved\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"owner\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"operator\",\"type\":\"address\"}],\"name\":\"isApprovedForAll\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"name\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"ownerOf\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"renounceOwnership\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"from\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"to\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"safeTransferFrom\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"from\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"to\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"},{\"internalType\":\"bytes\",\"name\":\"_data\",\"type\":\"bytes\"}],\"name\":\"safeTransferFrom\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"operator\",\"type\":\"address\"},{\"internalType\":\"bool\",\"name\":\"approved\",\"type\":\"bool\"}],\"name\":\"setApprovalForAll\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"string\",\"name\":\"_newBaseURI\",\"type\":\"string\"}],\"name\":\"setBaseURI\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"bytes4\",\"name\":\"interfaceId\",\"type\":\"bytes4\"}],\"name\":\"supportsInterface\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"symbol\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"index\",\"type\":\"uint256\"}],\"name\":\"tokenByIndex\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"owner\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"index\",\"type\":\"uint256\"}],\"name\":\"tokenOfOwnerByIndex\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"tokenURI\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"totalSupply\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"from\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"to\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"transferFrom\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"tokenID\",\"type\":\"uint256\"}],\"name\":\"unwrap\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"bytes5\",\"name\":\"catId\",\"type\":\"bytes5\"}],\"name\":\"wrap\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"}]"})

(def mooncatacclimator
  {:address "0xc3f733ca98e0dad0386979eb96fb1722a1a05e69"
   :abi "[{\"inputs\":[{\"internalType\":\"string\",\"name\":\"baseURI\",\"type\":\"string\"}],\"stateMutability\":\"nonpayable\",\"type\":\"constructor\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"owner\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"approved\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"Approval\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"owner\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"operator\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"bool\",\"name\":\"approved\",\"type\":\"bool\"}],\"name\":\"ApprovalForAll\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"owner\",\"type\":\"address\"}],\"name\":\"MoonCatAcclimated\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"owner\",\"type\":\"address\"}],\"name\":\"MoonCatDeacclimated\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"previousOwner\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"newOwner\",\"type\":\"address\"}],\"name\":\"OwnershipTransferred\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"address\",\"name\":\"account\",\"type\":\"address\"}],\"name\":\"Paused\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"_from\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"uint256\",\"name\":\"_toTokenId\",\"type\":\"uint256\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"_childContract\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"_childTokenId\",\"type\":\"uint256\"}],\"name\":\"ReceivedChild\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"from\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"to\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"Transfer\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"uint256\",\"name\":\"_fromTokenId\",\"type\":\"uint256\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"_to\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"_childContract\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"uint256\",\"name\":\"_childTokenId\",\"type\":\"uint256\"}],\"name\":\"TransferChild\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":false,\"internalType\":\"address\",\"name\":\"account\",\"type\":\"address\"}],\"name\":\"Unpaused\",\"type\":\"event\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_to\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"_tokenId\",\"type\":\"uint256\"}],\"name\":\"approve\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_owner\",\"type\":\"address\"}],\"name\":\"balanceOf\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"baseURI\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256[]\",\"name\":\"_rescueOrders\",\"type\":\"uint256[]\"},{\"internalType\":\"uint256[]\",\"name\":\"_oldTokenIds\",\"type\":\"uint256[]\"}],\"name\":\"batchReWrap\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256[]\",\"name\":\"_rescueOrders\",\"type\":\"uint256[]\"}],\"name\":\"batchUnwrap\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256[]\",\"name\":\"_rescueOrders\",\"type\":\"uint256[]\"}],\"name\":\"batchWrap\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_rescueOrder\",\"type\":\"uint256\"}],\"name\":\"buyAndWrap\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"payable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_tokenId\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"_index\",\"type\":\"uint256\"}],\"name\":\"childContractByIndex\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"childContract\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_tokenId\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"_childContract\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"_index\",\"type\":\"uint256\"}],\"name\":\"childTokenByIndex\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"childTokenId\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"getApproved\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_from\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"_tokenId\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"_childContract\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"_childTokenId\",\"type\":\"uint256\"}],\"name\":\"getChild\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_owner\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"_operator\",\"type\":\"address\"}],\"name\":\"isApprovedForAll\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"name\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_operator\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"_from\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"_oldTokenId\",\"type\":\"uint256\"},{\"internalType\":\"bytes\",\"name\":\"_data\",\"type\":\"bytes\"}],\"name\":\"onERC721Received\",\"outputs\":[{\"internalType\":\"bytes4\",\"name\":\"\",\"type\":\"bytes4\"}],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"owner\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_tokenId\",\"type\":\"uint256\"}],\"name\":\"ownerOf\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_childContract\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"_childTokenId\",\"type\":\"uint256\"}],\"name\":\"ownerOfChild\",\"outputs\":[{\"internalType\":\"bytes32\",\"name\":\"parentTokenOwner\",\"type\":\"bytes32\"},{\"internalType\":\"uint256\",\"name\":\"parentTokenId\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"pause\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"paused\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"renounceOwnership\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"rescueOrderLookup\",\"outputs\":[{\"internalType\":\"contract MoonCatOrderLookup\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_tokenId\",\"type\":\"uint256\"}],\"name\":\"rootOwnerOf\",\"outputs\":[{\"internalType\":\"bytes32\",\"name\":\"rootOwner\",\"type\":\"bytes32\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_childContract\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"_childTokenId\",\"type\":\"uint256\"}],\"name\":\"rootOwnerOfChild\",\"outputs\":[{\"internalType\":\"bytes32\",\"name\":\"rootOwner\",\"type\":\"bytes32\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_fromTokenId\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"_to\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"_childContract\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"_childTokenId\",\"type\":\"uint256\"}],\"name\":\"safeTransferChild\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_fromTokenId\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"_to\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"_childContract\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"_childTokenId\",\"type\":\"uint256\"},{\"internalType\":\"bytes\",\"name\":\"_data\",\"type\":\"bytes\"}],\"name\":\"safeTransferChild\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"from\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"to\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"safeTransferFrom\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"from\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"to\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"},{\"internalType\":\"bytes\",\"name\":\"_data\",\"type\":\"bytes\"}],\"name\":\"safeTransferFrom\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"operator\",\"type\":\"address\"},{\"internalType\":\"bool\",\"name\":\"approved\",\"type\":\"bool\"}],\"name\":\"setApprovalForAll\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"string\",\"name\":\"_newBaseURI\",\"type\":\"string\"}],\"name\":\"setBaseURI\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"bytes4\",\"name\":\"interfaceId\",\"type\":\"bytes4\"}],\"name\":\"supportsInterface\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"symbol\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"index\",\"type\":\"uint256\"}],\"name\":\"tokenByIndex\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_owner\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"_index\",\"type\":\"uint256\"}],\"name\":\"tokenOfOwnerByIndex\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"tokenURI\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"owner\",\"type\":\"address\"}],\"name\":\"tokensIdsByOwner\",\"outputs\":[{\"internalType\":\"uint256[]\",\"name\":\"\",\"type\":\"uint256[]\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_tokenId\",\"type\":\"uint256\"}],\"name\":\"totalChildContracts\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_tokenId\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"_childContract\",\"type\":\"address\"}],\"name\":\"totalChildTokens\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"totalSupply\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_fromTokenId\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"_to\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"_childContract\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"_childTokenId\",\"type\":\"uint256\"}],\"name\":\"transferChild\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_fromTokenId\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"_toContract\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"_toTokenId\",\"type\":\"uint256\"},{\"internalType\":\"address\",\"name\":\"_childContract\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"_childTokenId\",\"type\":\"uint256\"},{\"internalType\":\"bytes\",\"name\":\"_data\",\"type\":\"bytes\"}],\"name\":\"transferChildToParent\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"from\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"to\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"tokenId\",\"type\":\"uint256\"}],\"name\":\"transferFrom\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"newOwner\",\"type\":\"address\"}],\"name\":\"transferOwnership\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"unpause\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_tokenId\",\"type\":\"uint256\"}],\"name\":\"unwrap\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_rescueOrder\",\"type\":\"uint256\"}],\"name\":\"wrap\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"nonpayable\",\"type\":\"function\"}]"})

(def mooncataccessories
  {:address "0x8d33303023723dE93b213da4EB53bE890e747C63"
   :abi "[{\"inputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"constructor\"},{\"anonymous\": false,\"inputs\": [{\"indexed\": false,\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"},{\"indexed\": false,\"internalType\": \"uint256\",\"name\": \"rescueOrder\",\"type\": \"uint256\"},{\"indexed\": false,\"internalType\": \"uint8\",\"name\": \"paletteIndex\",\"type\": \"uint8\"},{\"indexed\": false,\"internalType\": \"uint16\",\"name\": \"zIndex\",\"type\": \"uint16\"}],\"name\": \"AccessoryApplied\",\"type\": \"event\"},{\"anonymous\": false,\"inputs\": [{\"indexed\": false,\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"},{\"indexed\": false,\"internalType\": \"address\",\"name\": \"creator\",\"type\": \"address\"},{\"indexed\": false,\"internalType\": \"uint256\",\"name\": \"price\",\"type\": \"uint256\"},{\"indexed\": false,\"internalType\": \"uint16\",\"name\": \"totalSupply\",\"type\": \"uint16\"},{\"indexed\": false,\"internalType\": \"bytes30\",\"name\": \"name\",\"type\": \"bytes30\"}],\"name\": \"AccessoryCreated\",\"type\": \"event\"},{\"anonymous\": false,\"inputs\": [{\"indexed\": false,\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"}],\"name\": \"AccessoryDiscontinued\",\"type\": \"event\"},{\"anonymous\": false,\"inputs\": [{\"indexed\": false,\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"},{\"indexed\": false,\"internalType\": \"address\",\"name\": \"newManager\",\"type\": \"address\"}],\"name\": \"AccessoryManagementTransferred\",\"type\": \"event\"},{\"anonymous\": false,\"inputs\": [{\"indexed\": false,\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"},{\"indexed\": false,\"internalType\": \"uint256\",\"name\": \"price\",\"type\": \"uint256\"}],\"name\": \"AccessoryPriceChanged\",\"type\": \"event\"},{\"anonymous\": false,\"inputs\": [{\"indexed\": false,\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"},{\"indexed\": false,\"internalType\": \"uint256\",\"name\": \"rescueOrder\",\"type\": \"uint256\"},{\"indexed\": false,\"internalType\": \"uint256\",\"name\": \"price\",\"type\": \"uint256\"}],\"name\": \"AccessoryPurchased\",\"type\": \"event\"},{\"anonymous\": false,\"inputs\": [{\"indexed\": false,\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"}],\"name\": \"EligibleListCleared\",\"type\": \"event\"},{\"anonymous\": false,\"inputs\": [{\"indexed\": false,\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"}],\"name\": \"EligibleListSet\",\"type\": \"event\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"\",\"type\": \"uint256\"},{\"internalType\": \"uint256\",\"name\": \"\",\"type\": \"uint256\"}],\"name\": \"AccessoriesByMoonCat\",\"outputs\": [{\"internalType\": \"uint232\",\"name\": \"accessoryId\",\"type\": \"uint232\"},{\"internalType\": \"uint8\",\"name\": \"paletteIndex\",\"type\": \"uint8\"},{\"internalType\": \"uint16\",\"name\": \"zIndex\",\"type\": \"uint16\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"}],\"name\": \"accessoryEligibleList\",\"outputs\": [{\"internalType\": \"bytes32[100]\",\"name\": \"\",\"type\": \"bytes32[100]\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"bytes32\",\"name\": \"\",\"type\": \"bytes32\"}],\"name\": \"accessoryHashes\",\"outputs\": [{\"internalType\": \"bool\",\"name\": \"\",\"type\": \"bool\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"}],\"name\": \"accessoryImageData\",\"outputs\": [{\"internalType\": \"bytes2[4]\",\"name\": \"positions\",\"type\": \"bytes2[4]\"},{\"internalType\": \"bytes8[7]\",\"name\": \"palettes\",\"type\": \"bytes8[7]\"},{\"internalType\": \"uint8\",\"name\": \"width\",\"type\": \"uint8\"},{\"internalType\": \"uint8\",\"name\": \"height\",\"type\": \"uint8\"},{\"internalType\": \"uint8\",\"name\": \"meta\",\"type\": \"uint8\"},{\"internalType\": \"bytes\",\"name\": \"IDAT\",\"type\": \"bytes\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"}],\"name\": \"accessoryInfo\",\"outputs\": [{\"internalType\": \"uint16\",\"name\": \"totalSupply\",\"type\": \"uint16\"},{\"internalType\": \"uint16\",\"name\": \"availableSupply\",\"type\": \"uint16\"},{\"internalType\": \"bytes28\",\"name\": \"name\",\"type\": \"bytes28\"},{\"internalType\": \"address\",\"name\": \"manager\",\"type\": \"address\"},{\"internalType\": \"uint8\",\"name\": \"metabyte\",\"type\": \"uint8\"},{\"internalType\": \"uint8\",\"name\": \"availablePalettes\",\"type\": \"uint8\"},{\"internalType\": \"bytes2[4]\",\"name\": \"positions\",\"type\": \"bytes2[4]\"},{\"internalType\": \"bool\",\"name\": \"availableForPurchase\",\"type\": \"bool\"},{\"internalType\": \"uint256\",\"name\": \"price\",\"type\": \"uint256\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"},{\"internalType\": \"uint256\",\"name\": \"paletteIndex\",\"type\": \"uint256\"}],\"name\": \"accessoryPalette\",\"outputs\": [{\"internalType\": \"bytes8\",\"name\": \"\",\"type\": \"bytes8\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"}],\"name\": \"accessoryPaletteCount\",\"outputs\": [{\"internalType\": \"uint8\",\"name\": \"\",\"type\": \"uint8\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"},{\"internalType\": \"bytes8\",\"name\": \"newPalette\",\"type\": \"bytes8\"}],\"name\": \"addAccessoryPalette\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"components\": [{\"internalType\": \"uint256\",\"name\": \"rescueOrder\",\"type\": \"uint256\"},{\"internalType\": \"uint232\",\"name\": \"ownedIndexOrAccessoryId\",\"type\": \"uint232\"},{\"internalType\": \"uint8\",\"name\": \"paletteIndex\",\"type\": \"uint8\"},{\"internalType\": \"uint16\",\"name\": \"zIndex\",\"type\": \"uint16\"}],\"internalType\": \"struct MoonCatAccessories.AccessoryBatchData[]\",\"name\": \"alterations\",\"type\": \"tuple[]\"}],\"name\": \"alterAccessories\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"rescueOrder\",\"type\": \"uint256\"},{\"internalType\": \"uint256\",\"name\": \"ownedAccessoryIndex\",\"type\": \"uint256\"},{\"internalType\": \"uint8\",\"name\": \"paletteIndex\",\"type\": \"uint8\"},{\"internalType\": \"uint16\",\"name\": \"zIndex\",\"type\": \"uint16\"}],\"name\": \"alterAccessory\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"address\",\"name\": \"manager\",\"type\": \"address\"}],\"name\": \"balanceOf\",\"outputs\": [{\"internalType\": \"uint256\",\"name\": \"\",\"type\": \"uint256\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"rescueOrder\",\"type\": \"uint256\"}],\"name\": \"balanceOf\",\"outputs\": [{\"internalType\": \"uint256\",\"name\": \"\",\"type\": \"uint256\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint8\",\"name\": \"value\",\"type\": \"uint8\"},{\"internalType\": \"uint256[]\",\"name\": \"accessoryIds\",\"type\": \"uint256[]\"}],\"name\": \"batchAndMetaByte\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint8\",\"name\": \"value\",\"type\": \"uint8\"},{\"internalType\": \"uint256[]\",\"name\": \"accessoryIds\",\"type\": \"uint256[]\"}],\"name\": \"batchOrMetaByte\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"components\": [{\"internalType\": \"uint256\",\"name\": \"rescueOrder\",\"type\": \"uint256\"},{\"internalType\": \"uint232\",\"name\": \"ownedIndexOrAccessoryId\",\"type\": \"uint232\"},{\"internalType\": \"uint8\",\"name\": \"paletteIndex\",\"type\": \"uint8\"},{\"internalType\": \"uint16\",\"name\": \"zIndex\",\"type\": \"uint16\"}],\"internalType\": \"struct MoonCatAccessories.AccessoryBatchData[]\",\"name\": \"orders\",\"type\": \"tuple[]\"},{\"internalType\": \"address payable\",\"name\": \"referrer\",\"type\": \"address\"}],\"name\": \"buyAccessories\",\"outputs\": [],\"stateMutability\": \"payable\",\"type\": \"function\"},{\"inputs\": [{\"components\": [{\"internalType\": \"uint256\",\"name\": \"rescueOrder\",\"type\": \"uint256\"},{\"internalType\": \"uint232\",\"name\": \"ownedIndexOrAccessoryId\",\"type\": \"uint232\"},{\"internalType\": \"uint8\",\"name\": \"paletteIndex\",\"type\": \"uint8\"},{\"internalType\": \"uint16\",\"name\": \"zIndex\",\"type\": \"uint16\"}],\"internalType\": \"struct MoonCatAccessories.AccessoryBatchData[]\",\"name\": \"orders\",\"type\": \"tuple[]\"}],\"name\": \"buyAccessories\",\"outputs\": [],\"stateMutability\": \"payable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"rescueOrder\",\"type\": \"uint256\"},{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"},{\"internalType\": \"uint8\",\"name\": \"paletteIndex\",\"type\": \"uint8\"},{\"internalType\": \"uint16\",\"name\": \"zIndex\",\"type\": \"uint16\"},{\"internalType\": \"address payable\",\"name\": \"referrer\",\"type\": \"address\"}],\"name\": \"buyAccessory\",\"outputs\": [{\"internalType\": \"uint256\",\"name\": \"\",\"type\": \"uint256\"}],\"stateMutability\": \"payable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"rescueOrder\",\"type\": \"uint256\"},{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"},{\"internalType\": \"uint8\",\"name\": \"paletteIndex\",\"type\": \"uint8\"},{\"internalType\": \"uint16\",\"name\": \"zIndex\",\"type\": \"uint16\"}],\"name\": \"buyAccessory\",\"outputs\": [{\"internalType\": \"uint256\",\"name\": \"\",\"type\": \"uint256\"}],\"stateMutability\": \"payable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"}],\"name\": \"clearEligibleList\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint8[3]\",\"name\": \"WHM\",\"type\": \"uint8[3]\"},{\"internalType\": \"uint256\",\"name\": \"priceWei\",\"type\": \"uint256\"},{\"internalType\": \"uint16\",\"name\": \"totalSupply\",\"type\": \"uint16\"},{\"internalType\": \"bytes28\",\"name\": \"name\",\"type\": \"bytes28\"},{\"internalType\": \"bytes2[4]\",\"name\": \"positions\",\"type\": \"bytes2[4]\"},{\"internalType\": \"bytes8[]\",\"name\": \"palettes\",\"type\": \"bytes8[]\"},{\"internalType\": \"bytes\",\"name\": \"IDAT\",\"type\": \"bytes\"},{\"internalType\": \"bytes32[100]\",\"name\": \"eligibleList\",\"type\": \"bytes32[100]\"}],\"name\": \"createAccessory\",\"outputs\": [{\"internalType\": \"uint256\",\"name\": \"\",\"type\": \"uint256\"}],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint8[3]\",\"name\": \"WHM\",\"type\": \"uint8[3]\"},{\"internalType\": \"uint256\",\"name\": \"priceWei\",\"type\": \"uint256\"},{\"internalType\": \"uint16\",\"name\": \"totalSupply\",\"type\": \"uint16\"},{\"internalType\": \"bytes28\",\"name\": \"name\",\"type\": \"bytes28\"},{\"internalType\": \"bytes2[4]\",\"name\": \"positions\",\"type\": \"bytes2[4]\"},{\"internalType\": \"bytes8[]\",\"name\": \"palettes\",\"type\": \"bytes8[]\"},{\"internalType\": \"bytes\",\"name\": \"IDAT\",\"type\": \"bytes\"}],\"name\": \"createAccessory\",\"outputs\": [{\"internalType\": \"uint256\",\"name\": \"\",\"type\": \"uint256\"}],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"}],\"name\": \"discontinueAccessory\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"rescueOrder\",\"type\": \"uint256\"},{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"}],\"name\": \"doesMoonCatOwnAccessory\",\"outputs\": [{\"internalType\": \"bool\",\"name\": \"\",\"type\": \"bool\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"},{\"internalType\": \"bool\",\"name\": \"targetState\",\"type\": \"bool\"},{\"internalType\": \"uint16[]\",\"name\": \"rescueOrders\",\"type\": \"uint16[]\"}],\"name\": \"editEligibleMoonCats\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [],\"name\": \"feeDenominator\",\"outputs\": [{\"internalType\": \"uint256\",\"name\": \"\",\"type\": \"uint256\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [],\"name\": \"freeze\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [],\"name\": \"frozen\",\"outputs\": [{\"internalType\": \"bool\",\"name\": \"\",\"type\": \"bool\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"bytes\",\"name\": \"IDAT\",\"type\": \"bytes\"}],\"name\": \"isAccessoryUnique\",\"outputs\": [{\"internalType\": \"bool\",\"name\": \"\",\"type\": \"bool\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"rescueOrder\",\"type\": \"uint256\"},{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"}],\"name\": \"isEligible\",\"outputs\": [{\"internalType\": \"bool\",\"name\": \"\",\"type\": \"bool\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"address\",\"name\": \"manager\",\"type\": \"address\"},{\"internalType\": \"uint256\",\"name\": \"managedAccessoryIndex\",\"type\": \"uint256\"}],\"name\": \"managedAccessoryByIndex\",\"outputs\": [{\"internalType\": \"uint256\",\"name\": \"\",\"type\": \"uint256\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"rescueOrder\",\"type\": \"uint256\"},{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"},{\"internalType\": \"uint8\",\"name\": \"paletteIndex\",\"type\": \"uint8\"},{\"internalType\": \"uint16\",\"name\": \"zIndex\",\"type\": \"uint16\"}],\"name\": \"managerApplyAccessory\",\"outputs\": [{\"internalType\": \"uint256\",\"name\": \"\",\"type\": \"uint256\"}],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"}],\"name\": \"managerOf\",\"outputs\": [{\"internalType\": \"address\",\"name\": \"\",\"type\": \"address\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"rescueOrder\",\"type\": \"uint256\"},{\"internalType\": \"uint256\",\"name\": \"ownedAccessoryIndex\",\"type\": \"uint256\"}],\"name\": \"ownedAccessoryByIndex\",\"outputs\": [{\"components\": [{\"internalType\": \"uint232\",\"name\": \"accessoryId\",\"type\": \"uint232\"},{\"internalType\": \"uint8\",\"name\": \"paletteIndex\",\"type\": \"uint8\"},{\"internalType\": \"uint16\",\"name\": \"zIndex\",\"type\": \"uint16\"}],\"internalType\": \"struct MoonCatAccessories.OwnedAccessory\",\"name\": \"\",\"type\": \"tuple\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [],\"name\": \"owner\",\"outputs\": [{\"internalType\": \"address payable\",\"name\": \"\",\"type\": \"address\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"address payable\",\"name\": \"manager\",\"type\": \"address\"},{\"internalType\": \"uint8[3]\",\"name\": \"WHM\",\"type\": \"uint8[3]\"},{\"internalType\": \"uint256\",\"name\": \"priceWei\",\"type\": \"uint256\"},{\"internalType\": \"uint16\",\"name\": \"totalSupply\",\"type\": \"uint16\"},{\"internalType\": \"bytes28\",\"name\": \"name\",\"type\": \"bytes28\"},{\"internalType\": \"bytes2[4]\",\"name\": \"positions\",\"type\": \"bytes2[4]\"},{\"internalType\": \"bytes8[7]\",\"name\": \"initialPalettes\",\"type\": \"bytes8[7]\"},{\"internalType\": \"bytes\",\"name\": \"IDAT\",\"type\": \"bytes\"},{\"internalType\": \"bytes32[100]\",\"name\": \"eligibleList\",\"type\": \"bytes32[100]\"}],\"name\": \"ownerCreateAccessory\",\"outputs\": [{\"internalType\": \"uint256\",\"name\": \"\",\"type\": \"uint256\"}],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"address payable\",\"name\": \"manager\",\"type\": \"address\"},{\"internalType\": \"uint8[3]\",\"name\": \"WHM\",\"type\": \"uint8[3]\"},{\"internalType\": \"uint256\",\"name\": \"priceWei\",\"type\": \"uint256\"},{\"internalType\": \"uint16\",\"name\": \"totalSupply\",\"type\": \"uint16\"},{\"internalType\": \"bytes28\",\"name\": \"name\",\"type\": \"bytes28\"},{\"internalType\": \"bytes2[4]\",\"name\": \"positions\",\"type\": \"bytes2[4]\"},{\"internalType\": \"bytes8[7]\",\"name\": \"initialPalettes\",\"type\": \"bytes8[7]\"},{\"internalType\": \"bytes\",\"name\": \"IDAT\",\"type\": \"bytes\"}],\"name\": \"ownerCreateAccessory\",\"outputs\": [{\"internalType\": \"uint256\",\"name\": \"\",\"type\": \"uint256\"}],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [],\"name\": \"referralDenominator\",\"outputs\": [{\"internalType\": \"uint256\",\"name\": \"\",\"type\": \"uint256\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"},{\"internalType\": \"uint256\",\"name\": \"newPriceWei\",\"type\": \"uint256\"}],\"name\": \"setAccessoryPrice\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"},{\"internalType\": \"bytes32[100]\",\"name\": \"eligibleList\",\"type\": \"bytes32[100]\"}],\"name\": \"setEligibleList\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"denominator\",\"type\": \"uint256\"}],\"name\": \"setFee\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"},{\"internalType\": \"uint8\",\"name\": \"metabyte\",\"type\": \"uint8\"}],\"name\": \"setMetaByte\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"denominator\",\"type\": \"uint256\"}],\"name\": \"setReferralFee\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"},{\"internalType\": \"bool\",\"name\": \"active\",\"type\": \"bool\"}],\"name\": \"toggleEligibleList\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [],\"name\": \"totalAccessories\",\"outputs\": [{\"internalType\": \"uint256\",\"name\": \"\",\"type\": \"uint256\"}],\"stateMutability\": \"view\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"uint256\",\"name\": \"accessoryId\",\"type\": \"uint256\"},{\"internalType\": \"address payable\",\"name\": \"newManager\",\"type\": \"address\"}],\"name\": \"transferAccessoryManagement\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"address payable\",\"name\": \"newOwner\",\"type\": \"address\"}],\"name\": \"transferOwnership\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [],\"name\": \"unfreeze\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"address\",\"name\": \"tokenContract\",\"type\": \"address\"}],\"name\": \"withdrawForeignERC20\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"},{\"inputs\": [{\"internalType\": \"address\",\"name\": \"tokenContract\",\"type\": \"address\"},{\"internalType\": \"uint256\",\"name\": \"tokenId\",\"type\": \"uint256\"}],\"name\": \"withdrawForeignERC721\",\"outputs\": [],\"stateMutability\": \"nonpayable\",\"type\": \"function\"}]"})

(def all
  {:mooncatrescue mooncatrescue
   :mooncatacclimator mooncatacclimator
   :mooncataccessories mooncataccessories
   :deprecated-unofficial-mooncat-wrapper deprecated-unofficial-mooncat-wrapper
   })

#?(:cljs (defn prep-abi [data]
           (assoc data :abiJSON (:abi data) :abi (js/JSON.parse (:abi data)))))

#?(:cljs (def all-js
           (clj->js
            {"MoonCatRescue" (prep-abi mooncatrescue)
             "MoonCatAcclimator" (prep-abi mooncatacclimator)
             "MoonCatAccessories" (prep-abi mooncataccessories)
             "DeprecatedUnofficialMoonCatWrapper" (prep-abi deprecated-unofficial-mooncat-wrapper)})))
