/*
 * Decompiled with CFR 0.152.
 */
package org.jblas;

import org.jblas.DoubleMatrix;
import org.jblas.NativeBlas;
import org.jblas.exceptions.LapackArgumentException;
import org.jblas.exceptions.LapackPositivityException;
import org.jblas.util.Functions;
import org.jblas.util.Permutations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Decompose {
    public static LUDecomposition<DoubleMatrix> lu(DoubleMatrix A) {
        int[] ipiv = new int[Functions.min(A.rows, A.columns)];
        DoubleMatrix result = A.dup();
        NativeBlas.dgetrf(A.rows, A.columns, result.data, 0, A.rows, ipiv, 0);
        DoubleMatrix l = new DoubleMatrix(A.rows, Functions.min(A.rows, A.columns));
        DoubleMatrix u = new DoubleMatrix(Functions.min(A.columns, A.rows), A.columns);
        Decompose.decomposeLowerUpper(result, l, u);
        DoubleMatrix p = Permutations.permutationMatrixFromPivotIndices(A.rows, ipiv);
        return new LUDecomposition<DoubleMatrix>(l, u, p);
    }

    private static void decomposeLowerUpper(DoubleMatrix A, DoubleMatrix L, DoubleMatrix U) {
        for (int i = 0; i < A.rows; ++i) {
            for (int j = 0; j < A.columns; ++j) {
                if (i < j) {
                    U.put(i, j, A.get(i, j));
                    continue;
                }
                if (i == j) {
                    U.put(i, i, A.get(i, i));
                    L.put(i, i, 1.0);
                    continue;
                }
                L.put(i, j, A.get(i, j));
            }
        }
    }

    public static DoubleMatrix cholesky(DoubleMatrix A) {
        DoubleMatrix result = A.dup();
        int info = NativeBlas.dpotrf('U', A.rows, result.data, 0, A.rows);
        if (info < 0) {
            throw new LapackArgumentException("DPOTRF", -info);
        }
        if (info > 0) {
            throw new LapackPositivityException("DPOTRF", "Minor " + info + " was negative. Matrix must be positive definite.");
        }
        Decompose.clearLower(result);
        return result;
    }

    private static void clearLower(DoubleMatrix A) {
        for (int j = 0; j < A.columns; ++j) {
            for (int i = j + 1; i < A.rows; ++i) {
                A.put(i, j, 0.0);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LUDecomposition<T> {
        public T l;
        public T u;
        public T p;

        public LUDecomposition(T l, T u, T p) {
            this.l = l;
            this.u = u;
            this.p = p;
        }
    }
}

