/*
 * Decompiled with CFR 0.152.
 */
package org.jblas.util;

public class Logger {
    public static final int ERROR = 5;
    public static final int WARNING = 4;
    public static final int INFO = 3;
    public static final int CONFIG = 2;
    public static final int DEBUG = 1;
    public static final String[] levelNames = new String[]{"DEBUG", "CONFIG", "INFO", "WARNING", "ERROR"};
    private static Logger theLogger = new Logger();
    private int level = 3;

    private Logger() {
    }

    public static Logger getLogger() {
        return theLogger;
    }

    public void log(int messageLevel, String msg) {
        if (this.level <= messageLevel) {
            System.err.println("-- org.jblas " + levelNames[messageLevel - 1] + " " + msg);
        }
    }

    public void debug(String msg) {
        this.log(1, msg);
    }

    public void config(String msg) {
        this.log(2, msg);
    }

    public void info(String msg) {
        this.log(3, msg);
    }

    public void warning(String msg) {
        this.log(4, msg);
    }

    public void error(String msg) {
        this.log(5, msg);
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

